/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow;

import io.zeebe.engine.processor.KeyGenerator;
import io.zeebe.engine.processor.TypedRecordProcessors;
import io.zeebe.engine.processor.workflow.BpmnStepProcessor;
import io.zeebe.engine.processor.workflow.CatchEventBehavior;
import io.zeebe.engine.processor.workflow.WorkflowInstanceCommandProcessor;
import io.zeebe.engine.processor.workflow.instance.CreateWorkflowInstanceProcessor;
import io.zeebe.engine.processor.workflow.message.CloseWorkflowInstanceSubscription;
import io.zeebe.engine.processor.workflow.message.CorrelateWorkflowInstanceSubscription;
import io.zeebe.engine.processor.workflow.message.OpenWorkflowInstanceSubscriptionProcessor;
import io.zeebe.engine.processor.workflow.message.command.SubscriptionCommandSender;
import io.zeebe.engine.processor.workflow.timer.CancelTimerProcessor;
import io.zeebe.engine.processor.workflow.timer.CreateTimerProcessor;
import io.zeebe.engine.processor.workflow.timer.DueDateTimerChecker;
import io.zeebe.engine.processor.workflow.timer.TriggerTimerProcessor;
import io.zeebe.engine.processor.workflow.variable.UpdateVariableDocumentProcessor;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.instance.ElementInstanceState;
import io.zeebe.engine.state.instance.VariablesState;
import io.zeebe.engine.state.instance.WorkflowEngineState;
import io.zeebe.engine.state.message.WorkflowInstanceSubscriptionState;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.TimerIntent;
import io.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.zeebe.protocol.record.intent.WorkflowInstanceCreationIntent;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.protocol.record.intent.WorkflowInstanceSubscriptionIntent;
import java.util.Arrays;
import java.util.List;

public class WorkflowEventProcessors {
    private static final List<WorkflowInstanceIntent> WORKFLOW_INSTANCE_COMMANDS = Arrays.asList(WorkflowInstanceIntent.CANCEL);

    private static boolean isWorkflowInstanceEvent(WorkflowInstanceIntent intent) {
        return !WORKFLOW_INSTANCE_COMMANDS.contains(intent);
    }

    public static BpmnStepProcessor addWorkflowProcessors(ZeebeState zeebeState, TypedRecordProcessors typedRecordProcessors, SubscriptionCommandSender subscriptionCommandSender, CatchEventBehavior catchEventBehavior, DueDateTimerChecker timerChecker) {
        WorkflowInstanceSubscriptionState subscriptionState = zeebeState.getWorkflowInstanceSubscriptionState();
        WorkflowEngineState workflowEngineState = new WorkflowEngineState(zeebeState.getWorkflowState());
        typedRecordProcessors.withListener(workflowEngineState);
        WorkflowEventProcessors.addWorkflowInstanceCommandProcessor(typedRecordProcessors, workflowEngineState, zeebeState);
        BpmnStepProcessor bpmnStepProcessor = new BpmnStepProcessor(workflowEngineState, zeebeState, catchEventBehavior);
        WorkflowEventProcessors.addBpmnStepProcessor(typedRecordProcessors, bpmnStepProcessor);
        WorkflowEventProcessors.addMessageStreamProcessors(typedRecordProcessors, subscriptionState, subscriptionCommandSender, zeebeState);
        WorkflowEventProcessors.addTimerStreamProcessors(typedRecordProcessors, timerChecker, zeebeState, catchEventBehavior);
        WorkflowEventProcessors.addVariableDocumentStreamProcessors(typedRecordProcessors, zeebeState);
        WorkflowEventProcessors.addWorkflowInstanceCreationStreamProcessors(typedRecordProcessors, zeebeState);
        return bpmnStepProcessor;
    }

    private static void addWorkflowInstanceCommandProcessor(TypedRecordProcessors typedRecordProcessors, WorkflowEngineState workflowEngineState, ZeebeState zeebeState) {
        WorkflowInstanceCommandProcessor commandProcessor = new WorkflowInstanceCommandProcessor(workflowEngineState, zeebeState.getKeyGenerator());
        WORKFLOW_INSTANCE_COMMANDS.forEach(intent -> typedRecordProcessors.onCommand(ValueType.WORKFLOW_INSTANCE, (Intent)intent, commandProcessor));
    }

    private static void addBpmnStepProcessor(TypedRecordProcessors typedRecordProcessors, BpmnStepProcessor bpmnStepProcessor) {
        Arrays.stream(WorkflowInstanceIntent.values()).filter(WorkflowEventProcessors::isWorkflowInstanceEvent).forEach(intent -> typedRecordProcessors.onEvent(ValueType.WORKFLOW_INSTANCE, (Intent)intent, bpmnStepProcessor));
    }

    private static void addMessageStreamProcessors(TypedRecordProcessors typedRecordProcessors, WorkflowInstanceSubscriptionState subscriptionState, SubscriptionCommandSender subscriptionCommandSender, ZeebeState zeebeState) {
        typedRecordProcessors.onCommand(ValueType.WORKFLOW_INSTANCE_SUBSCRIPTION, (Intent)WorkflowInstanceSubscriptionIntent.OPEN, new OpenWorkflowInstanceSubscriptionProcessor(subscriptionState)).onCommand(ValueType.WORKFLOW_INSTANCE_SUBSCRIPTION, (Intent)WorkflowInstanceSubscriptionIntent.CORRELATE, new CorrelateWorkflowInstanceSubscription(subscriptionState, subscriptionCommandSender, zeebeState)).onCommand(ValueType.WORKFLOW_INSTANCE_SUBSCRIPTION, (Intent)WorkflowInstanceSubscriptionIntent.CLOSE, new CloseWorkflowInstanceSubscription(subscriptionState));
    }

    private static void addTimerStreamProcessors(TypedRecordProcessors typedRecordProcessors, DueDateTimerChecker timerChecker, ZeebeState zeebeState, CatchEventBehavior catchEventOutput) {
        WorkflowState workflowState = zeebeState.getWorkflowState();
        typedRecordProcessors.onCommand(ValueType.TIMER, (Intent)TimerIntent.CREATE, new CreateTimerProcessor(zeebeState, timerChecker)).onCommand(ValueType.TIMER, (Intent)TimerIntent.TRIGGER, new TriggerTimerProcessor(zeebeState, catchEventOutput)).onCommand(ValueType.TIMER, (Intent)TimerIntent.CANCEL, new CancelTimerProcessor(workflowState)).withListener(timerChecker);
    }

    private static void addVariableDocumentStreamProcessors(TypedRecordProcessors typedRecordProcessors, ZeebeState zeebeState) {
        ElementInstanceState elementInstanceState = zeebeState.getWorkflowState().getElementInstanceState();
        VariablesState variablesState = elementInstanceState.getVariablesState();
        typedRecordProcessors.onCommand(ValueType.VARIABLE_DOCUMENT, (Intent)VariableDocumentIntent.UPDATE, new UpdateVariableDocumentProcessor(elementInstanceState, variablesState));
    }

    private static void addWorkflowInstanceCreationStreamProcessors(TypedRecordProcessors typedRecordProcessors, ZeebeState zeebeState) {
        WorkflowState workflowState = zeebeState.getWorkflowState();
        ElementInstanceState elementInstanceState = workflowState.getElementInstanceState();
        VariablesState variablesState = elementInstanceState.getVariablesState();
        KeyGenerator keyGenerator = zeebeState.getKeyGenerator();
        typedRecordProcessors.onCommand(ValueType.WORKFLOW_INSTANCE_CREATION, (Intent)WorkflowInstanceCreationIntent.CREATE, new CreateWorkflowInstanceProcessor(workflowState, elementInstanceState, variablesState, keyGenerator));
    }
}

