/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow;

import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.EventOutput;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;

public class WorkflowInstanceCommandContext {
    private TypedRecord<WorkflowInstanceRecord> record;
    private final EventOutput eventOutput;
    private ElementInstance elementInstance;
    private TypedResponseWriter responseWriter;
    private TypedStreamWriter streamWriter;

    public WorkflowInstanceCommandContext(EventOutput eventOutput) {
        this.eventOutput = eventOutput;
    }

    public WorkflowInstanceIntent getCommand() {
        return (WorkflowInstanceIntent)this.record.getMetadata().getIntent();
    }

    public TypedRecord<WorkflowInstanceRecord> getRecord() {
        return this.record;
    }

    public void setRecord(TypedRecord<WorkflowInstanceRecord> record) {
        this.record = record;
    }

    public EventOutput getOutput() {
        return this.eventOutput;
    }

    public ElementInstance getElementInstance() {
        return this.elementInstance;
    }

    public void setElementInstance(ElementInstance elementInstance) {
        this.elementInstance = elementInstance;
    }

    public TypedResponseWriter getResponseWriter() {
        return this.responseWriter;
    }

    public void setResponseWriter(TypedResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    public void setStreamWriter(TypedStreamWriter writer) {
        this.streamWriter = writer;
        this.eventOutput.setStreamWriter(writer);
    }

    public void reject(RejectionType rejectionType, String reason) {
        this.streamWriter.appendRejection(this.record, rejectionType, reason);
        this.responseWriter.writeRejectionOnCommand(this.record, rejectionType, reason);
    }
}

