/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow;

import io.zeebe.engine.processor.KeyGenerator;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.EventOutput;
import io.zeebe.engine.processor.workflow.WorkflowInstanceCommandContext;
import io.zeebe.engine.processor.workflow.WorkflowInstanceCommandHandlers;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.WorkflowEngineState;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;

public class WorkflowInstanceCommandProcessor
implements TypedRecordProcessor<WorkflowInstanceRecord> {
    private final WorkflowInstanceCommandHandlers commandHandlers;
    private final WorkflowEngineState state;
    private final WorkflowInstanceCommandContext context;

    public WorkflowInstanceCommandProcessor(WorkflowEngineState state, KeyGenerator keyGenerator) {
        this.state = state;
        this.commandHandlers = new WorkflowInstanceCommandHandlers();
        EventOutput output = new EventOutput(state, keyGenerator);
        this.context = new WorkflowInstanceCommandContext(output);
    }

    @Override
    public void processRecord(TypedRecord<WorkflowInstanceRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        this.populateCommandContext(record, responseWriter, streamWriter);
        this.commandHandlers.handle(this.context);
    }

    private void populateCommandContext(TypedRecord<WorkflowInstanceRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        this.context.setRecord(record);
        this.context.setResponseWriter(responseWriter);
        this.context.setStreamWriter(streamWriter);
        ElementInstance elementInstance = this.state.getElementInstanceState().getInstance(record.getKey());
        this.context.setElementInstance(elementInstance);
    }
}

