/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow;

import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public class WorkflowInstanceLifecycle {
    public static final EnumSet<WorkflowInstanceIntent> ELEMENT_INSTANCE_STATES = EnumSet.of(WorkflowInstanceIntent.ELEMENT_ACTIVATING, new WorkflowInstanceIntent[]{WorkflowInstanceIntent.ELEMENT_ACTIVATED, WorkflowInstanceIntent.ELEMENT_COMPLETING, WorkflowInstanceIntent.ELEMENT_COMPLETED, WorkflowInstanceIntent.ELEMENT_TERMINATING, WorkflowInstanceIntent.ELEMENT_TERMINATED});
    public static final EnumSet<WorkflowInstanceIntent> FINAL_ELEMENT_INSTANCE_STATES = EnumSet.of(WorkflowInstanceIntent.ELEMENT_COMPLETED, WorkflowInstanceIntent.ELEMENT_TERMINATED);
    public static final EnumSet<WorkflowInstanceIntent> TERMINATABLE_STATES = EnumSet.of(WorkflowInstanceIntent.ELEMENT_ACTIVATING, WorkflowInstanceIntent.ELEMENT_ACTIVATED, WorkflowInstanceIntent.ELEMENT_COMPLETING);
    public static final Map<WorkflowInstanceIntent, Set<WorkflowInstanceIntent>> TRANSITION_RULES = new EnumMap<WorkflowInstanceIntent, Set<WorkflowInstanceIntent>>(WorkflowInstanceIntent.class);

    public static boolean canTransition(WorkflowInstanceIntent from, WorkflowInstanceIntent to) {
        return TRANSITION_RULES.get(from).contains(to);
    }

    public static boolean isFinalState(WorkflowInstanceIntent state) {
        return FINAL_ELEMENT_INSTANCE_STATES.contains(state);
    }

    public static boolean isInitialState(WorkflowInstanceIntent state) {
        return state == WorkflowInstanceIntent.ELEMENT_ACTIVATING;
    }

    public static boolean isElementInstanceState(WorkflowInstanceIntent state) {
        return ELEMENT_INSTANCE_STATES.contains(state);
    }

    public static boolean isTokenState(WorkflowInstanceIntent state) {
        return !WorkflowInstanceLifecycle.isElementInstanceState(state);
    }

    public static boolean canTerminate(WorkflowInstanceIntent currentState) {
        return TERMINATABLE_STATES.contains(currentState);
    }

    public static boolean isActive(WorkflowInstanceIntent currentState) {
        return currentState == WorkflowInstanceIntent.ELEMENT_ACTIVATED;
    }

    public static boolean isTerminating(WorkflowInstanceIntent currentState) {
        return currentState == WorkflowInstanceIntent.ELEMENT_TERMINATING;
    }

    static {
        TRANSITION_RULES.put(WorkflowInstanceIntent.ELEMENT_ACTIVATING, EnumSet.of(WorkflowInstanceIntent.ELEMENT_ACTIVATED, WorkflowInstanceIntent.ELEMENT_TERMINATING));
        TRANSITION_RULES.put(WorkflowInstanceIntent.ELEMENT_ACTIVATED, EnumSet.of(WorkflowInstanceIntent.ELEMENT_COMPLETING, WorkflowInstanceIntent.ELEMENT_TERMINATING));
        TRANSITION_RULES.put(WorkflowInstanceIntent.ELEMENT_COMPLETING, EnumSet.of(WorkflowInstanceIntent.ELEMENT_COMPLETED, WorkflowInstanceIntent.ELEMENT_TERMINATING));
        TRANSITION_RULES.put(WorkflowInstanceIntent.ELEMENT_TERMINATING, EnumSet.of(WorkflowInstanceIntent.ELEMENT_TERMINATED));
        TRANSITION_RULES.put(WorkflowInstanceIntent.ELEMENT_COMPLETED, Collections.emptySet());
        TRANSITION_RULES.put(WorkflowInstanceIntent.ELEMENT_TERMINATED, Collections.emptySet());
    }
}

