/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow;

import io.zeebe.util.metrics.Metric;
import io.zeebe.util.metrics.MetricsManager;

public class WorkflowInstanceMetrics
implements AutoCloseable {
    private final Metric workflowInstanceEventCreated;
    private final Metric workflowInstanceEventCanceled;
    private final Metric workflowInstanceEventCompleted;

    public WorkflowInstanceMetrics(MetricsManager metricsManager, int partitionId) {
        String partitionIdString = Integer.toString(partitionId);
        this.workflowInstanceEventCanceled = metricsManager.newMetric("workflow_instance_events_count").type("counter").label("partition", partitionIdString).label("type", "canceled").create();
        this.workflowInstanceEventCompleted = metricsManager.newMetric("workflow_instance_events_count").type("counter").label("partition", partitionIdString).label("type", "completed").create();
        this.workflowInstanceEventCreated = metricsManager.newMetric("workflow_instance_events_count").type("counter").label("partition", partitionIdString).label("type", "created").create();
    }

    public void countInstanceCanceled() {
        this.workflowInstanceEventCanceled.incrementOrdered();
    }

    public void countInstanceCompleted() {
        this.workflowInstanceEventCompleted.incrementOrdered();
    }

    public void countInstanceCreated() {
        this.workflowInstanceEventCreated.incrementOrdered();
    }

    @Override
    public void close() {
        this.workflowInstanceEventCreated.close();
        this.workflowInstanceEventCanceled.close();
        this.workflowInstanceEventCompleted.close();
    }
}

