/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment;

import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.DeploymentIntent;
import io.zeebe.protocol.record.intent.Intent;

public class DeploymentCreateProcessor
implements TypedRecordProcessor<DeploymentRecord> {
    public static final String DEPLOYMENT_ALREADY_EXISTS_MESSAGE = "Expected to create a new deployment with key '%d', but there is already an existing deployment with that key";
    private final WorkflowState workflowState;

    public DeploymentCreateProcessor(WorkflowState workflowState) {
        this.workflowState = workflowState;
    }

    @Override
    public void processRecord(TypedRecord<DeploymentRecord> event, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        DeploymentRecord deploymentEvent = event.getValue();
        if (this.workflowState.putDeployment(event.getKey(), deploymentEvent)) {
            streamWriter.appendFollowUpEvent(event.getKey(), (Intent)DeploymentIntent.CREATED, (UnpackedObject)deploymentEvent);
        } else {
            streamWriter.appendRejection(event, RejectionType.ALREADY_EXISTS, String.format(DEPLOYMENT_ALREADY_EXISTS_MESSAGE, event.getKey()));
        }
    }
}

