/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment;

import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableCatchEventElement;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableWorkflow;
import io.zeebe.engine.state.deployment.DeployedWorkflow;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.impl.record.value.deployment.Workflow;
import io.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.zeebe.protocol.record.intent.DeploymentIntent;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import java.util.List;

public class DeploymentCreatedProcessor
implements TypedRecordProcessor<DeploymentRecord> {
    private final WorkflowState workflowState;
    private final boolean isDeploymentPartition;
    private final MessageStartEventSubscriptionRecord subscriptionRecord = new MessageStartEventSubscriptionRecord();

    public DeploymentCreatedProcessor(WorkflowState workflowState, boolean isDeploymentPartition) {
        this.workflowState = workflowState;
        this.isDeploymentPartition = isDeploymentPartition;
    }

    @Override
    public void processRecord(TypedRecord<DeploymentRecord> event, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        DeploymentRecord deploymentEvent = event.getValue();
        if (this.isDeploymentPartition) {
            streamWriter.appendFollowUpCommand(event.getKey(), (Intent)DeploymentIntent.DISTRIBUTE, (UnpackedObject)deploymentEvent);
        }
        for (Workflow workflowRecord : deploymentEvent.workflows()) {
            if (!this.isLatestWorkflow(workflowRecord)) continue;
            this.closeExistingMessageStartEventSubscriptions(workflowRecord, streamWriter);
            this.openMessageStartEventSubscriptions(workflowRecord, streamWriter);
        }
    }

    private boolean isLatestWorkflow(Workflow workflow) {
        return this.workflowState.getLatestWorkflowVersionByProcessId(workflow.getBpmnProcessIdBuffer()).getVersion() == workflow.getVersion();
    }

    private void closeExistingMessageStartEventSubscriptions(Workflow workflowRecord, TypedStreamWriter streamWriter) {
        DeployedWorkflow lastMsgWorkflow = this.findLastMessageStartWorkflow(workflowRecord);
        if (lastMsgWorkflow == null) {
            return;
        }
        this.subscriptionRecord.reset();
        this.subscriptionRecord.setWorkflowKey(lastMsgWorkflow.getKey());
        streamWriter.appendNewCommand((Intent)MessageStartEventSubscriptionIntent.CLOSE, (UnpackedObject)this.subscriptionRecord);
    }

    private DeployedWorkflow findLastMessageStartWorkflow(Workflow workflowRecord) {
        for (int version = workflowRecord.getVersion() - 1; version > 0; --version) {
            DeployedWorkflow lastMsgWorkflow = this.workflowState.getWorkflowByProcessIdAndVersion(workflowRecord.getBpmnProcessIdBuffer(), version);
            if (lastMsgWorkflow == null || !lastMsgWorkflow.getWorkflow().getStartEvents().stream().anyMatch(e -> e.isMessage())) continue;
            return lastMsgWorkflow;
        }
        return null;
    }

    private void openMessageStartEventSubscriptions(Workflow workflowRecord, TypedStreamWriter streamWriter) {
        long workflowKey = workflowRecord.getKey();
        DeployedWorkflow workflowDefinition = this.workflowState.getWorkflowByKey(workflowKey);
        ExecutableWorkflow workflow = workflowDefinition.getWorkflow();
        List<ExecutableCatchEventElement> startEvents = workflow.getStartEvents();
        for (ExecutableCatchEventElement startEvent : startEvents) {
            if (!startEvent.isMessage()) continue;
            this.subscriptionRecord.reset();
            this.subscriptionRecord.setMessageName(startEvent.getMessage().getMessageName()).setWorkflowKey(workflowKey).setStartEventId(startEvent.getId());
            streamWriter.appendNewCommand((Intent)MessageStartEventSubscriptionIntent.OPEN, (UnpackedObject)this.subscriptionRecord);
        }
    }
}

