/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment;

import io.zeebe.engine.processor.KeyGenerator;
import io.zeebe.engine.processor.SideEffectProducer;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.CatchEventBehavior;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableCatchEventElement;
import io.zeebe.engine.processor.workflow.deployment.transform.DeploymentTransformer;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.instance.TimerInstance;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.impl.record.value.deployment.Workflow;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.DeploymentIntent;
import io.zeebe.protocol.record.intent.Intent;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public class TransformingDeploymentCreateProcessor
implements TypedRecordProcessor<DeploymentRecord> {
    public static final String DEPLOYMENT_ALREADY_EXISTS_MESSAGE = "Expected to create a new deployment with key '%d', but there is already an existing deployment with that key";
    private final DeploymentTransformer deploymentTransformer;
    private final WorkflowState workflowState;
    private final CatchEventBehavior catchEventBehavior;
    private final KeyGenerator keyGenerator;

    public TransformingDeploymentCreateProcessor(ZeebeState zeebeState, CatchEventBehavior catchEventBehavior) {
        this.workflowState = zeebeState.getWorkflowState();
        this.keyGenerator = zeebeState.getKeyGenerator();
        this.deploymentTransformer = new DeploymentTransformer(zeebeState);
        this.catchEventBehavior = catchEventBehavior;
    }

    @Override
    public void processRecord(TypedRecord<DeploymentRecord> command, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        DeploymentRecord deploymentEvent = command.getValue();
        boolean accepted = this.deploymentTransformer.transform(deploymentEvent);
        if (accepted) {
            long key = this.keyGenerator.nextKey();
            if (this.workflowState.putDeployment(key, deploymentEvent)) {
                responseWriter.writeEventOnCommand(key, (Intent)DeploymentIntent.CREATED, (UnpackedObject)deploymentEvent, command);
                streamWriter.appendFollowUpEvent(key, (Intent)DeploymentIntent.CREATED, (UnpackedObject)deploymentEvent);
                this.createTimerIfTimerStartEvent(command, streamWriter);
            } else {
                String reason = String.format(DEPLOYMENT_ALREADY_EXISTS_MESSAGE, key);
                responseWriter.writeRejectionOnCommand(command, RejectionType.ALREADY_EXISTS, reason);
                streamWriter.appendRejection(command, RejectionType.ALREADY_EXISTS, reason);
            }
        } else {
            responseWriter.writeRejectionOnCommand(command, this.deploymentTransformer.getRejectionType(), this.deploymentTransformer.getRejectionReason());
            streamWriter.appendRejection(command, this.deploymentTransformer.getRejectionType(), this.deploymentTransformer.getRejectionReason());
        }
    }

    private void createTimerIfTimerStartEvent(TypedRecord<DeploymentRecord> record, TypedStreamWriter streamWriter) {
        for (Workflow workflow : record.getValue().workflows()) {
            List<ExecutableCatchEventElement> startEvents = this.workflowState.getWorkflowByKey(workflow.getKey()).getWorkflow().getStartEvents();
            boolean hasAtLeastOneTimer = false;
            this.unsubscribeFromPreviousTimers(streamWriter, workflow);
            for (ExecutableCatchEventElement startEvent : startEvents) {
                if (!startEvent.isTimer()) continue;
                hasAtLeastOneTimer = true;
                this.catchEventBehavior.subscribeToTimerEvent(-1L, -1L, workflow.getKey(), startEvent.getId(), startEvent.getTimer(), streamWriter);
            }
            if (!hasAtLeastOneTimer) continue;
            this.workflowState.getEventScopeInstanceState().createIfNotExists(workflow.getKey(), Collections.emptyList());
        }
    }

    private void unsubscribeFromPreviousTimers(TypedStreamWriter streamWriter, Workflow workflow) {
        this.workflowState.getTimerState().forEachTimerForElementInstance(-1L, timer -> this.unsubscribeFromPreviousTimer(streamWriter, workflow, (TimerInstance)timer));
    }

    private void unsubscribeFromPreviousTimer(TypedStreamWriter streamWriter, Workflow workflow, TimerInstance timer) {
        DirectBuffer timerBpmnId = this.workflowState.getWorkflowByKey(timer.getWorkflowKey()).getBpmnProcessId();
        if (timerBpmnId.equals(workflow.getBpmnProcessIdBuffer())) {
            this.catchEventBehavior.unsubscribeFromTimerEvent(timer, streamWriter);
        }
    }
}

