/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.distribute;

import io.zeebe.engine.processor.ReadonlyProcessingContext;
import io.zeebe.engine.processor.SideEffectProducer;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.deployment.distribute.DeploymentDistributor;
import io.zeebe.engine.processor.workflow.deployment.distribute.PendingDeploymentDistribution;
import io.zeebe.engine.state.deployment.DeploymentsState;
import io.zeebe.logstreams.log.LogStreamWriterImpl;
import io.zeebe.protocol.impl.record.RecordMetadata;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.DeploymentIntent;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.util.buffer.BufferWriter;
import io.zeebe.util.sched.ActorControl;
import io.zeebe.util.sched.future.ActorFuture;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;

public class DeploymentDistributeProcessor
implements TypedRecordProcessor<DeploymentRecord> {
    private final LogStreamWriterImpl logStreamWriter;
    private final DeploymentsState deploymentsState;
    private ActorControl actor;
    private final DeploymentDistributor deploymentDistributor;
    private int streamProcessorId;
    private int partitionId;

    public DeploymentDistributeProcessor(DeploymentsState deploymentsState, LogStreamWriterImpl logStreamWriter, DeploymentDistributor deploymentDistributor) {
        this.deploymentsState = deploymentsState;
        this.logStreamWriter = logStreamWriter;
        this.deploymentDistributor = deploymentDistributor;
    }

    @Override
    public void onOpen(ReadonlyProcessingContext processingContext) {
        this.partitionId = processingContext.getLogStream().getPartitionId();
        this.streamProcessorId = processingContext.getProducerId();
        this.actor = processingContext.getActor();
        this.actor.submit(this::reprocessPendingDeployments);
    }

    private void reprocessPendingDeployments() {
        this.deploymentsState.foreachPending((pendingDeploymentDistribution, key) -> {
            ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
            DirectBuffer deployment = pendingDeploymentDistribution.getDeployment();
            buffer.putBytes(0, deployment, 0, deployment.capacity());
            this.distributeDeployment(key, pendingDeploymentDistribution.getSourcePosition(), (DirectBuffer)buffer);
        });
    }

    @Override
    public void processRecord(long position, TypedRecord<DeploymentRecord> event, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        DeploymentRecord deploymentEvent = event.getValue();
        long key = event.getKey();
        ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
        deploymentEvent.write((MutableDirectBuffer)buffer, 0);
        this.distributeDeployment(key, position, (DirectBuffer)buffer);
    }

    private void distributeDeployment(long key, long position, DirectBuffer buffer) {
        ActorFuture<Void> pushDeployment = this.deploymentDistributor.pushDeployment(key, position, buffer);
        this.actor.runOnCompletion(pushDeployment, (aVoid, throwable) -> this.writeCreatingDeploymentCommand(key));
    }

    private void writeCreatingDeploymentCommand(long deploymentKey) {
        PendingDeploymentDistribution pendingDeploymentDistribution = this.deploymentDistributor.removePendingDeployment(deploymentKey);
        DirectBuffer buffer = pendingDeploymentDistribution.getDeployment();
        long sourcePosition = pendingDeploymentDistribution.getSourcePosition();
        DeploymentRecord deploymentRecord = new DeploymentRecord();
        deploymentRecord.wrap(buffer);
        RecordMetadata recordMetadata = new RecordMetadata();
        recordMetadata.partitionId(this.partitionId).intent((Intent)DeploymentIntent.DISTRIBUTED).valueType(ValueType.DEPLOYMENT).recordType(RecordType.EVENT);
        this.actor.runUntilDone(() -> {
            long position = this.logStreamWriter.key(deploymentKey).producerId(this.streamProcessorId).sourceRecordPosition(sourcePosition).valueWriter((BufferWriter)deploymentRecord).metadataWriter((BufferWriter)recordMetadata).tryWrite();
            if (position < 0L) {
                this.actor.yield();
            } else {
                this.actor.done();
            }
        });
    }
}

