/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.distribute;

import io.zeebe.db.DbValue;
import io.zeebe.db.impl.ZeebeDbConstants;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class PendingDeploymentDistribution
implements DbValue {
    private static final int DEPLOYMENT_LENGTH_OFFSET = 8;
    private static final int DEPLOYMENT_OFFSET = 12;
    private final DirectBuffer deployment;
    private long sourcePosition;
    private long distributionCount;

    public PendingDeploymentDistribution(DirectBuffer deployment, long sourcePosition) {
        this.deployment = deployment;
        this.sourcePosition = sourcePosition;
    }

    public void setDistributionCount(long distributionCount) {
        this.distributionCount = distributionCount;
    }

    public long decrementCount() {
        return --this.distributionCount;
    }

    public DirectBuffer getDeployment() {
        return this.deployment;
    }

    public long getSourcePosition() {
        return this.sourcePosition;
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.sourcePosition = buffer.getLong(offset, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        int deploymentSize = buffer.getInt(offset += 8, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.deployment.wrap(buffer, offset += 4, deploymentSize);
    }

    public int getLength() {
        int deploymentSize = this.deployment.capacity();
        int length = 12 + deploymentSize;
        return length;
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        int startOffset = offset;
        buffer.putLong(offset, this.sourcePosition, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        int deploymentSize = this.deployment.capacity();
        buffer.putInt(offset += 8, deploymentSize, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putBytes(offset += 4, this.deployment, 0, deploymentSize);
        assert (startOffset + this.getLength() == (offset += deploymentSize));
    }
}

