/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.model.element;

import io.zeebe.engine.processor.workflow.deployment.model.BpmnStep;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowElement;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;
import io.zeebe.util.buffer.BufferUtil;
import java.util.EnumMap;
import java.util.Map;
import org.agrona.DirectBuffer;

public abstract class AbstractFlowElement
implements ExecutableFlowElement {
    private final DirectBuffer id;
    private final Map<WorkflowInstanceIntent, BpmnStep> bpmnSteps = new EnumMap<WorkflowInstanceIntent, BpmnStep>(WorkflowInstanceIntent.class);
    private BpmnElementType elementType;

    public AbstractFlowElement(String id) {
        this.id = BufferUtil.wrapString((String)id);
        this.elementType = BpmnElementType.UNSPECIFIED;
    }

    @Override
    public DirectBuffer getId() {
        return this.id;
    }

    public void bindLifecycleState(WorkflowInstanceIntent state, BpmnStep step) {
        this.bpmnSteps.put(state, step);
    }

    @Override
    public BpmnStep getStep(WorkflowInstanceIntent state) {
        return this.bpmnSteps.get(state);
    }

    public void setElementType(BpmnElementType elementType) {
        this.elementType = elementType;
    }

    @Override
    public BpmnElementType getElementType() {
        return this.elementType;
    }
}

