/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.model.element;

import io.zeebe.engine.processor.workflow.deployment.model.element.AbstractFlowElement;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowElement;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowElementContainer;
import io.zeebe.util.buffer.BufferUtil;
import java.util.HashMap;
import java.util.Map;
import org.agrona.DirectBuffer;

public class ExecutableWorkflow
extends ExecutableFlowElementContainer {
    private final Map<DirectBuffer, AbstractFlowElement> flowElements = new HashMap<DirectBuffer, AbstractFlowElement>();

    public ExecutableWorkflow(String id) {
        super(id);
        this.addFlowElement(this);
    }

    public void addFlowElement(AbstractFlowElement element) {
        this.flowElements.put(element.getId(), element);
    }

    public AbstractFlowElement getElementById(DirectBuffer id) {
        return this.flowElements.get(id);
    }

    public <T extends ExecutableFlowElement> T getElementById(String id, Class<T> expectedType) {
        DirectBuffer buffer = BufferUtil.wrapString((String)id);
        ExecutableFlowElement element = this.flowElements.get(buffer);
        if (element == null) {
            return null;
        }
        if (expectedType.isAssignableFrom(element.getClass())) {
            return (T)element;
        }
        throw new RuntimeException(String.format("Expected element with id '%s' to be instance of class '%s', but it is an instance of '%s'", id, expectedType.getSimpleName(), element.getClass().getSimpleName()));
    }
}

