/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.model.transformation;

import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableWorkflow;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.TransformContext;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.TransformationVisitor;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.ActivityTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.BoundaryEventTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.CatchEventTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.ContextProcessTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.EndEventTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.EventBasedGatewayTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.ExclusiveGatewayTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.FlowElementInstantiationTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.FlowNodeTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.IntermediateCatchEventTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.MessageTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.ParallelGatewayTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.ProcessTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.ReceiveTaskTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.SequenceFlowTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.ServiceTaskTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.StartEventTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformer.SubProcessTransformer;
import io.zeebe.model.bpmn.BpmnModelInstance;
import io.zeebe.model.bpmn.traversal.ModelElementVisitor;
import io.zeebe.model.bpmn.traversal.ModelWalker;
import io.zeebe.msgpack.jsonpath.JsonPathQueryCompiler;
import java.util.List;

public class BpmnTransformer {
    private final TransformationVisitor step1Visitor;
    private final TransformationVisitor step2Visitor;
    private final TransformationVisitor step3Visitor;
    private final JsonPathQueryCompiler jsonPathQueryCompiler = new JsonPathQueryCompiler();

    public BpmnTransformer() {
        this.step1Visitor = new TransformationVisitor();
        this.step1Visitor.registerHandler(new FlowElementInstantiationTransformer());
        this.step1Visitor.registerHandler(new MessageTransformer());
        this.step1Visitor.registerHandler(new ProcessTransformer());
        this.step2Visitor = new TransformationVisitor();
        this.step2Visitor.registerHandler(new ActivityTransformer());
        this.step2Visitor.registerHandler(new BoundaryEventTransformer());
        this.step2Visitor.registerHandler(new CatchEventTransformer());
        this.step2Visitor.registerHandler(new ContextProcessTransformer());
        this.step2Visitor.registerHandler(new EndEventTransformer());
        this.step2Visitor.registerHandler(new FlowNodeTransformer());
        this.step2Visitor.registerHandler(new ParallelGatewayTransformer());
        this.step2Visitor.registerHandler(new SequenceFlowTransformer());
        this.step2Visitor.registerHandler(new ServiceTaskTransformer());
        this.step2Visitor.registerHandler(new ReceiveTaskTransformer());
        this.step2Visitor.registerHandler(new StartEventTransformer());
        this.step2Visitor.registerHandler(new SubProcessTransformer());
        this.step3Visitor = new TransformationVisitor();
        this.step3Visitor.registerHandler(new ContextProcessTransformer());
        this.step3Visitor.registerHandler(new EventBasedGatewayTransformer());
        this.step3Visitor.registerHandler(new ExclusiveGatewayTransformer());
        this.step3Visitor.registerHandler(new IntermediateCatchEventTransformer());
    }

    public List<ExecutableWorkflow> transformDefinitions(BpmnModelInstance modelInstance) {
        TransformContext context = new TransformContext();
        context.setJsonPathQueryCompiler(this.jsonPathQueryCompiler);
        ModelWalker walker = new ModelWalker(modelInstance);
        this.step1Visitor.setContext(context);
        walker.walk((ModelElementVisitor)this.step1Visitor);
        this.step2Visitor.setContext(context);
        walker.walk((ModelElementVisitor)this.step2Visitor);
        this.step3Visitor.setContext(context);
        walker.walk((ModelElementVisitor)this.step3Visitor);
        return context.getWorkflows();
    }
}

