/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.model.transformation;

import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableMessage;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableWorkflow;
import io.zeebe.msgpack.jsonpath.JsonPathQueryCompiler;
import io.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.agrona.DirectBuffer;

public class TransformContext {
    private final Map<DirectBuffer, ExecutableWorkflow> workflows = new HashMap<DirectBuffer, ExecutableWorkflow>();
    private final Map<DirectBuffer, ExecutableMessage> messages = new HashMap<DirectBuffer, ExecutableMessage>();
    private JsonPathQueryCompiler jsonPathQueryCompiler;
    private ExecutableWorkflow currentWorkflow;

    public ExecutableWorkflow getCurrentWorkflow() {
        return this.currentWorkflow;
    }

    public void addWorkflow(ExecutableWorkflow workflow) {
        this.workflows.put(workflow.getId(), workflow);
    }

    public void setCurrentWorkflow(ExecutableWorkflow currentWorkflow) {
        this.currentWorkflow = currentWorkflow;
    }

    public ExecutableWorkflow getWorkflow(String id) {
        return this.workflows.get(BufferUtil.wrapString((String)id));
    }

    public List<ExecutableWorkflow> getWorkflows() {
        return new ArrayList<ExecutableWorkflow>(this.workflows.values());
    }

    public void addMessage(ExecutableMessage message) {
        this.messages.put(message.getId(), message);
    }

    public ExecutableMessage getMessage(String id) {
        return this.messages.get(BufferUtil.wrapString((String)id));
    }

    public JsonPathQueryCompiler getJsonPathQueryCompiler() {
        return this.jsonPathQueryCompiler;
    }

    public void setJsonPathQueryCompiler(JsonPathQueryCompiler jsonPathQueryCompiler) {
        this.jsonPathQueryCompiler = jsonPathQueryCompiler;
    }
}

