/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.model.transformer;

import io.zeebe.engine.processor.workflow.deployment.model.BpmnStep;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableCatchEventElement;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableMessage;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableWorkflow;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.ModelElementTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.TransformContext;
import io.zeebe.model.bpmn.instance.CatchEvent;
import io.zeebe.model.bpmn.instance.EventDefinition;
import io.zeebe.model.bpmn.instance.Message;
import io.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.zeebe.model.bpmn.instance.TimerEventDefinition;
import io.zeebe.model.bpmn.util.time.Interval;
import io.zeebe.model.bpmn.util.time.RepeatingInterval;
import io.zeebe.model.bpmn.util.time.TimeDateTimer;
import io.zeebe.model.bpmn.util.time.Timer;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;

public class CatchEventTransformer
implements ModelElementTransformer<CatchEvent> {
    @Override
    public Class<CatchEvent> getType() {
        return CatchEvent.class;
    }

    @Override
    public void transform(CatchEvent element, TransformContext context) {
        ExecutableWorkflow workflow = context.getCurrentWorkflow();
        ExecutableCatchEventElement executableElement = workflow.getElementById(element.getId(), ExecutableCatchEventElement.class);
        executableElement.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_COMPLETED, BpmnStep.FLOWOUT_ELEMENT_COMPLETED);
        if (!element.getEventDefinitions().isEmpty()) {
            this.transformEventDefinition(element, context, executableElement);
        }
    }

    private void transformEventDefinition(CatchEvent element, TransformContext context, ExecutableCatchEventElement executableElement) {
        EventDefinition eventDefinition = (EventDefinition)element.getEventDefinitions().iterator().next();
        if (eventDefinition instanceof MessageEventDefinition) {
            this.transformMessageEventDefinition(context, executableElement, (MessageEventDefinition)eventDefinition);
        } else if (eventDefinition instanceof TimerEventDefinition) {
            this.transformTimerEventDefinition(executableElement, (TimerEventDefinition)eventDefinition);
        }
    }

    private void transformMessageEventDefinition(TransformContext context, ExecutableCatchEventElement executableElement, MessageEventDefinition messageEventDefinition) {
        Message message = messageEventDefinition.getMessage();
        ExecutableMessage executableMessage = context.getMessage(message.getId());
        executableElement.setMessage(executableMessage);
    }

    private void transformTimerEventDefinition(ExecutableCatchEventElement executableElement, TimerEventDefinition timerEventDefinition) {
        RepeatingInterval timer;
        if (timerEventDefinition.getTimeDuration() != null) {
            String duration = timerEventDefinition.getTimeDuration().getTextContent();
            timer = new RepeatingInterval(1, Interval.parse((String)duration));
        } else if (timerEventDefinition.getTimeCycle() != null) {
            String cycle = timerEventDefinition.getTimeCycle().getTextContent();
            timer = RepeatingInterval.parse((String)cycle);
        } else {
            String timeDate = timerEventDefinition.getTimeDate().getTextContent();
            timer = TimeDateTimer.parse((String)timeDate);
        }
        executableElement.setTimer((Timer)timer);
    }
}

