/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.model.transformer;

import io.zeebe.engine.processor.workflow.deployment.model.BpmnStep;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableCatchEvent;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableEventBasedGateway;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableWorkflow;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.ModelElementTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.TransformContext;
import io.zeebe.model.bpmn.instance.EventBasedGateway;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import java.util.List;
import java.util.stream.Collectors;

public class EventBasedGatewayTransformer
implements ModelElementTransformer<EventBasedGateway> {
    @Override
    public Class<EventBasedGateway> getType() {
        return EventBasedGateway.class;
    }

    @Override
    public void transform(EventBasedGateway element, TransformContext context) {
        ExecutableWorkflow workflow = context.getCurrentWorkflow();
        ExecutableEventBasedGateway gateway = workflow.getElementById(element.getId(), ExecutableEventBasedGateway.class);
        List<ExecutableCatchEvent> connectedEvents = this.getConnectedCatchEvents(gateway);
        gateway.setEvents(connectedEvents);
        this.bindLifecycle(gateway);
    }

    private List<ExecutableCatchEvent> getConnectedCatchEvents(ExecutableEventBasedGateway gateway) {
        return gateway.getOutgoing().stream().map(e -> (ExecutableCatchEvent)((Object)e.getTarget())).collect(Collectors.toList());
    }

    private void bindLifecycle(ExecutableEventBasedGateway gateway) {
        gateway.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_ACTIVATING, BpmnStep.EVENT_BASED_GATEWAY_ELEMENT_ACTIVATING);
        gateway.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_ACTIVATED, BpmnStep.EVENT_BASED_GATEWAY_ELEMENT_ACTIVATED);
        gateway.bindLifecycleState(WorkflowInstanceIntent.EVENT_OCCURRED, BpmnStep.EVENT_BASED_GATEWAY_EVENT_OCCURRED);
        gateway.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_COMPLETING, BpmnStep.EVENT_BASED_GATEWAY_ELEMENT_COMPLETING);
        gateway.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_COMPLETED, BpmnStep.EVENT_BASED_GATEWAY_ELEMENT_COMPLETED);
        gateway.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_TERMINATING, BpmnStep.EVENT_BASED_GATEWAY_ELEMENT_TERMINATING);
    }
}

