/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.model.transformer;

import io.zeebe.engine.processor.workflow.deployment.model.BpmnStep;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableExclusiveGateway;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableSequenceFlow;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableWorkflow;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.ModelElementTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.TransformContext;
import io.zeebe.model.bpmn.instance.ExclusiveGateway;
import io.zeebe.model.bpmn.instance.SequenceFlow;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import java.util.List;

public class ExclusiveGatewayTransformer
implements ModelElementTransformer<ExclusiveGateway> {
    @Override
    public Class<ExclusiveGateway> getType() {
        return ExclusiveGateway.class;
    }

    @Override
    public void transform(ExclusiveGateway element, TransformContext context) {
        ExecutableWorkflow workflow = context.getCurrentWorkflow();
        ExecutableExclusiveGateway gateway = workflow.getElementById(element.getId(), ExecutableExclusiveGateway.class);
        this.transformDefaultFlow(element, workflow, gateway);
        this.bindLifecycle(gateway);
    }

    private void bindLifecycle(ExecutableExclusiveGateway gateway) {
        boolean hasSingleNonConditionalOutgoingFlow;
        List<ExecutableSequenceFlow> outgoingFlows = gateway.getOutgoing();
        boolean hasNoOutgoingFlows = outgoingFlows.size() == 0;
        boolean bl = hasSingleNonConditionalOutgoingFlow = outgoingFlows.size() == 1 && ((ExecutableSequenceFlow)outgoingFlows.iterator().next()).getCondition() == null;
        if (hasNoOutgoingFlows || hasSingleNonConditionalOutgoingFlow) {
            gateway.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_COMPLETED, BpmnStep.FLOWOUT_ELEMENT_COMPLETED);
        } else {
            gateway.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_ACTIVATING, BpmnStep.EXCLUSIVE_GATEWAY_ELEMENT_ACTIVATING);
            gateway.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_COMPLETED, BpmnStep.EXCLUSIVE_GATEWAY_ELEMENT_COMPLETED);
        }
    }

    private void transformDefaultFlow(ExclusiveGateway element, ExecutableWorkflow workflow, ExecutableExclusiveGateway gateway) {
        SequenceFlow defaultFlowElement = element.getDefault();
        if (defaultFlowElement != null) {
            String defaultFlowId = defaultFlowElement.getId();
            ExecutableSequenceFlow defaultFlow = workflow.getElementById(defaultFlowId, ExecutableSequenceFlow.class);
            gateway.setDefaultFlow(defaultFlow);
        }
    }
}

