/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.model.transformer;

import io.zeebe.engine.processor.workflow.deployment.model.BpmnStep;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowNode;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableWorkflow;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.ModelElementTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.TransformContext;
import io.zeebe.model.bpmn.instance.FlowNode;
import io.zeebe.model.bpmn.instance.zeebe.ZeebeIoMapping;
import io.zeebe.msgpack.mapping.Mapping;
import io.zeebe.msgpack.mapping.MappingBuilder;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import java.util.Collection;

public class FlowNodeTransformer
implements ModelElementTransformer<FlowNode> {
    private final MappingBuilder mappingBuilder = new MappingBuilder();

    @Override
    public Class<FlowNode> getType() {
        return FlowNode.class;
    }

    @Override
    public void transform(FlowNode flowNode, TransformContext context) {
        ExecutableWorkflow workflow = context.getCurrentWorkflow();
        ExecutableFlowNode element = workflow.getElementById(flowNode.getId(), ExecutableFlowNode.class);
        this.transformIoMappings(flowNode, element, context);
        this.bindLifecycle(element);
    }

    private void bindLifecycle(ExecutableFlowNode element) {
        element.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_ACTIVATING, BpmnStep.ELEMENT_ACTIVATING);
        element.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_ACTIVATED, BpmnStep.ELEMENT_ACTIVATED);
        element.bindLifecycleState(WorkflowInstanceIntent.EVENT_OCCURRED, BpmnStep.EVENT_OCCURRED);
        element.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_COMPLETING, BpmnStep.ELEMENT_COMPLETING);
        element.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_COMPLETED, BpmnStep.ELEMENT_COMPLETED);
        element.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_TERMINATING, BpmnStep.ELEMENT_TERMINATING);
        element.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_TERMINATED, BpmnStep.ELEMENT_TERMINATED);
    }

    private void transformIoMappings(FlowNode element, ExecutableFlowNode flowNode, TransformContext context) {
        ZeebeIoMapping ioMapping = (ZeebeIoMapping)element.getSingleExtensionElement(ZeebeIoMapping.class);
        if (ioMapping != null) {
            Collection inputs = ioMapping.getInputs();
            inputs.forEach(i -> this.mappingBuilder.mapping(i.getSource(), i.getTarget()));
            Mapping[] inputMappings = this.mappingBuilder.build();
            Collection outputs = ioMapping.getOutputs();
            outputs.forEach(o -> this.mappingBuilder.mapping(o.getSource(), o.getTarget()));
            Mapping[] outputMappings = this.mappingBuilder.build();
            flowNode.setInputMappings(inputMappings);
            flowNode.setOutputMappings(outputMappings);
        }
    }
}

