/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.model.transformer;

import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableMessage;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.ModelElementTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.TransformContext;
import io.zeebe.model.bpmn.instance.ExtensionElements;
import io.zeebe.model.bpmn.instance.Message;
import io.zeebe.model.bpmn.instance.zeebe.ZeebeSubscription;
import io.zeebe.msgpack.jsonpath.JsonPathQuery;
import io.zeebe.msgpack.jsonpath.JsonPathQueryCompiler;
import io.zeebe.util.buffer.BufferUtil;

public class MessageTransformer
implements ModelElementTransformer<Message> {
    @Override
    public Class<Message> getType() {
        return Message.class;
    }

    @Override
    public void transform(Message element, TransformContext context) {
        String id = element.getId();
        ExecutableMessage executableElement = new ExecutableMessage(id);
        ExtensionElements extensionElements = element.getExtensionElements();
        if (extensionElements != null) {
            ZeebeSubscription subscription = (ZeebeSubscription)extensionElements.getElementsQuery().filterByType(ZeebeSubscription.class).singleResult();
            JsonPathQueryCompiler queryCompiler = context.getJsonPathQueryCompiler();
            JsonPathQuery query = queryCompiler.compile(subscription.getCorrelationKey());
            executableElement.setCorrelationKey(query);
        }
        if (element.getName() != null) {
            executableElement.setMessageName(BufferUtil.wrapString((String)element.getName()));
            context.addMessage(executableElement);
        }
    }
}

