/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.model.transformer;

import io.zeebe.engine.processor.workflow.deployment.model.BpmnStep;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableWorkflow;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.ModelElementTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.TransformContext;
import io.zeebe.model.bpmn.instance.Process;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;

public class ProcessTransformer
implements ModelElementTransformer<Process> {
    @Override
    public Class<Process> getType() {
        return Process.class;
    }

    @Override
    public void transform(Process element, TransformContext context) {
        String id = element.getId();
        ExecutableWorkflow workflow = new ExecutableWorkflow(id);
        workflow.setElementType(BpmnElementType.bpmnElementTypeFor((String)element.getElementType().getTypeName()));
        context.addWorkflow(workflow);
        context.setCurrentWorkflow(workflow);
        workflow.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_ACTIVATING, BpmnStep.ELEMENT_ACTIVATING);
        workflow.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_ACTIVATED, BpmnStep.CONTAINER_ELEMENT_ACTIVATED);
        workflow.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_COMPLETING, BpmnStep.ELEMENT_COMPLETING);
        workflow.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_COMPLETED, BpmnStep.ELEMENT_COMPLETED);
        workflow.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_TERMINATING, BpmnStep.CONTAINER_ELEMENT_TERMINATING);
        workflow.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_TERMINATED, BpmnStep.ELEMENT_TERMINATED);
    }
}

