/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.model.transformer;

import io.zeebe.engine.processor.workflow.deployment.model.BpmnStep;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableMessage;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableReceiveTask;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableWorkflow;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.ModelElementTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.TransformContext;
import io.zeebe.model.bpmn.instance.Message;
import io.zeebe.model.bpmn.instance.ReceiveTask;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;

public class ReceiveTaskTransformer
implements ModelElementTransformer<ReceiveTask> {
    @Override
    public Class<ReceiveTask> getType() {
        return ReceiveTask.class;
    }

    @Override
    public void transform(ReceiveTask element, TransformContext context) {
        ExecutableWorkflow workflow = context.getCurrentWorkflow();
        ExecutableReceiveTask executableElement = workflow.getElementById(element.getId(), ExecutableReceiveTask.class);
        Message message = element.getMessage();
        ExecutableMessage executableMessage = context.getMessage(message.getId());
        executableElement.setMessage(executableMessage);
        this.bindLifecycle(executableElement);
    }

    private void bindLifecycle(ExecutableReceiveTask executableElement) {
        executableElement.bindLifecycleState(WorkflowInstanceIntent.EVENT_OCCURRED, BpmnStep.RECEIVE_TASK_EVENT_OCCURRED);
    }
}

