/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.model.transformer;

import io.zeebe.engine.processor.workflow.deployment.model.BpmnStep;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowNode;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableSequenceFlow;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableWorkflow;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.ModelElementTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.TransformContext;
import io.zeebe.model.bpmn.instance.ConditionExpression;
import io.zeebe.model.bpmn.instance.SequenceFlow;
import io.zeebe.msgpack.el.CompiledJsonCondition;
import io.zeebe.msgpack.el.JsonConditionFactory;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;

public class SequenceFlowTransformer
implements ModelElementTransformer<SequenceFlow> {
    @Override
    public Class<SequenceFlow> getType() {
        return SequenceFlow.class;
    }

    @Override
    public void transform(SequenceFlow element, TransformContext context) {
        ExecutableWorkflow workflow = context.getCurrentWorkflow();
        ExecutableSequenceFlow sequenceFlow = workflow.getElementById(element.getId(), ExecutableSequenceFlow.class);
        this.compileCondition(element, sequenceFlow);
        this.connectWithFlowNodes(element, workflow, sequenceFlow);
        this.bindLifecycle(sequenceFlow);
    }

    private void bindLifecycle(ExecutableSequenceFlow sequenceFlow) {
        ExecutableFlowNode target = sequenceFlow.getTarget();
        if (target.getElementType() == BpmnElementType.PARALLEL_GATEWAY) {
            sequenceFlow.bindLifecycleState(WorkflowInstanceIntent.SEQUENCE_FLOW_TAKEN, BpmnStep.PARALLEL_MERGE_SEQUENCE_FLOW_TAKEN);
        } else {
            sequenceFlow.bindLifecycleState(WorkflowInstanceIntent.SEQUENCE_FLOW_TAKEN, BpmnStep.SEQUENCE_FLOW_TAKEN);
        }
    }

    private void connectWithFlowNodes(SequenceFlow element, ExecutableWorkflow workflow, ExecutableSequenceFlow sequenceFlow) {
        ExecutableFlowNode source = workflow.getElementById(element.getSource().getId(), ExecutableFlowNode.class);
        ExecutableFlowNode target = workflow.getElementById(element.getTarget().getId(), ExecutableFlowNode.class);
        source.addOutgoing(sequenceFlow);
        target.addIncoming(sequenceFlow);
        sequenceFlow.setTarget(target);
        sequenceFlow.setSource(source);
    }

    private void compileCondition(SequenceFlow element, ExecutableSequenceFlow sequenceFlow) {
        ConditionExpression conditionExpression = element.getConditionExpression();
        if (conditionExpression != null) {
            String rawExpression = conditionExpression.getTextContent();
            CompiledJsonCondition compiledExpression = JsonConditionFactory.createCondition((String)rawExpression);
            sequenceFlow.setCondition(compiledExpression);
        }
    }
}

