/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.model.transformer;

import io.zeebe.engine.Loggers;
import io.zeebe.engine.processor.workflow.deployment.model.BpmnStep;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableServiceTask;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableWorkflow;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.ModelElementTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.TransformContext;
import io.zeebe.model.bpmn.instance.ServiceTask;
import io.zeebe.model.bpmn.instance.zeebe.ZeebeHeader;
import io.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import io.zeebe.model.bpmn.instance.zeebe.ZeebeTaskHeaders;
import io.zeebe.msgpack.spec.MsgPackWriter;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public class ServiceTaskTransformer
implements ModelElementTransformer<ServiceTask> {
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private static final int INITIAL_SIZE_KEY_VALUE_PAIR = 128;
    private final MsgPackWriter msgPackWriter = new MsgPackWriter();

    @Override
    public Class<ServiceTask> getType() {
        return ServiceTask.class;
    }

    @Override
    public void transform(ServiceTask element, TransformContext context) {
        ExecutableWorkflow workflow = context.getCurrentWorkflow();
        ExecutableServiceTask serviceTask = workflow.getElementById(element.getId(), ExecutableServiceTask.class);
        this.transformTaskDefinition(element, serviceTask);
        this.transformTaskHeaders(element, serviceTask);
        this.bindLifecycle(serviceTask);
    }

    private void bindLifecycle(ExecutableServiceTask serviceTask) {
        serviceTask.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_ACTIVATED, BpmnStep.SERVICE_TASK_ELEMENT_ACTIVATED);
        serviceTask.bindLifecycleState(WorkflowInstanceIntent.ELEMENT_TERMINATING, BpmnStep.SERVICE_TASK_ELEMENT_TERMINATING);
    }

    private void transformTaskDefinition(ServiceTask element, ExecutableServiceTask serviceTask) {
        ZeebeTaskDefinition taskDefinition = (ZeebeTaskDefinition)element.getSingleExtensionElement(ZeebeTaskDefinition.class);
        serviceTask.setType(taskDefinition.getType());
        serviceTask.setRetries(taskDefinition.getRetries());
    }

    private void transformTaskHeaders(ServiceTask element, ExecutableServiceTask serviceTask) {
        ZeebeTaskHeaders taskHeaders = (ZeebeTaskHeaders)element.getSingleExtensionElement(ZeebeTaskHeaders.class);
        if (taskHeaders != null) {
            List<ZeebeHeader> validHeaders = taskHeaders.getHeaders().stream().filter(this::isValidHeader).collect(Collectors.toList());
            if (validHeaders.size() < taskHeaders.getHeaders().size()) {
                LOG.warn("Ignoring invalid headers for task '{}'. Must have non-empty key and value.", (Object)element.getName());
            }
            if (!validHeaders.isEmpty()) {
                DirectBuffer encodedHeaders = this.encode(validHeaders);
                serviceTask.setEncodedHeaders(encodedHeaders);
            }
        }
    }

    private DirectBuffer encode(List<ZeebeHeader> taskHeaders) {
        UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);
        ExpandableArrayBuffer expandableBuffer = new ExpandableArrayBuffer(128 * taskHeaders.size());
        this.msgPackWriter.wrap((MutableDirectBuffer)expandableBuffer, 0);
        this.msgPackWriter.writeMapHeader(taskHeaders.size());
        taskHeaders.forEach(h -> {
            if (this.isValidHeader((ZeebeHeader)h)) {
                DirectBuffer key = BufferUtil.wrapString((String)h.getKey());
                this.msgPackWriter.writeString(key);
                DirectBuffer value = BufferUtil.wrapString((String)h.getValue());
                this.msgPackWriter.writeString(value);
            }
        });
        buffer.wrap(expandableBuffer.byteArray(), 0, this.msgPackWriter.getOffset());
        return buffer;
    }

    private boolean isValidHeader(ZeebeHeader header) {
        return header != null && header.getValue() != null && !header.getValue().isEmpty() && header.getKey() != null && !header.getKey().isEmpty();
    }
}

