/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.model.transformer;

import io.zeebe.engine.processor.workflow.deployment.model.BpmnStep;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableCatchEventElement;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowElementContainer;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableWorkflow;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.ModelElementTransformer;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.TransformContext;
import io.zeebe.model.bpmn.instance.FlowNode;
import io.zeebe.model.bpmn.instance.StartEvent;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;

public class StartEventTransformer
implements ModelElementTransformer<StartEvent> {
    @Override
    public Class<StartEvent> getType() {
        return StartEvent.class;
    }

    @Override
    public void transform(StartEvent element, TransformContext context) {
        ExecutableWorkflow workflow = context.getCurrentWorkflow();
        ExecutableCatchEventElement startEvent = workflow.getElementById(element.getId(), ExecutableCatchEventElement.class);
        if (element.getScope() instanceof FlowNode) {
            FlowNode scope = (FlowNode)element.getScope();
            ExecutableFlowElementContainer subprocess = workflow.getElementById(scope.getId(), ExecutableFlowElementContainer.class);
            subprocess.addStartEvent(startEvent);
        } else {
            workflow.addStartEvent(startEvent);
        }
        this.bindLifecycle(startEvent);
    }

    private void bindLifecycle(ExecutableCatchEventElement startEvent) {
        startEvent.bindLifecycleState(WorkflowInstanceIntent.EVENT_OCCURRED, BpmnStep.START_EVENT_EVENT_OCCURRED);
    }
}

