/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.model.validation;

import io.zeebe.msgpack.el.CompiledJsonCondition;
import io.zeebe.msgpack.el.JsonConditionFactory;
import io.zeebe.msgpack.jsonpath.JsonPathQuery;
import io.zeebe.msgpack.jsonpath.JsonPathQueryCompiler;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class ZeebeExpressionValidator {
    public void validateExpression(String expression, ValidationResultCollector resultCollector) {
        CompiledJsonCondition condition = JsonConditionFactory.createCondition((String)expression);
        if (!condition.isValid()) {
            resultCollector.addError(0, String.format("Condition expression is invalid: %s", condition.getErrorMessage()));
        }
    }

    public void validateJsonPath(String jsonPath, ValidationResultCollector resultCollector) {
        if (jsonPath == null) {
            resultCollector.addError(0, String.format("JSON path query is empty", new Object[0]));
            return;
        }
        JsonPathQueryCompiler queryCompiler = new JsonPathQueryCompiler();
        JsonPathQuery compiledQuery = queryCompiler.compile(jsonPath);
        if (!compiledQuery.isValid()) {
            resultCollector.addError(0, String.format("JSON path query is invalid: %s", compiledQuery.getErrorReason()));
        }
    }
}

