/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.model.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.zeebe.engine.processor.workflow.deployment.model.yaml.YamlCase;
import io.zeebe.engine.processor.workflow.deployment.model.yaml.YamlDefinitionImpl;
import io.zeebe.engine.processor.workflow.deployment.model.yaml.YamlMapping;
import io.zeebe.engine.processor.workflow.deployment.model.yaml.YamlTask;
import io.zeebe.model.bpmn.Bpmn;
import io.zeebe.model.bpmn.BpmnModelInstance;
import io.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.zeebe.model.bpmn.builder.StartEventBuilder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BpmnYamlParser {
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private YamlDefinitionImpl definition;
    private final Map<String, YamlTask> tasksById = new HashMap<String, YamlTask>();
    private final List<String> createdTasks = new ArrayList<String>();

    public BpmnModelInstance readFromStream(InputStream inputStream) {
        YamlDefinitionImpl definition;
        try {
            definition = (YamlDefinitionImpl)this.mapper.readValue(inputStream, YamlDefinitionImpl.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error trying to read BPMN YAML model", e);
        }
        return this.createWorkflow(definition);
    }

    private BpmnModelInstance createWorkflow(YamlDefinitionImpl definition) {
        this.definition = definition;
        this.createdTasks.clear();
        this.tasksById.clear();
        for (YamlTask task : definition.getTasks()) {
            this.tasksById.put(task.getId(), task);
        }
        StartEventBuilder builder = Bpmn.createExecutableProcess((String)definition.getName()).startEvent();
        YamlTask initialTask = definition.getTasks().get(0);
        this.addTask((AbstractFlowNodeBuilder<?, ?>)builder, initialTask.getId());
        return builder.done();
    }

    private void addTask(AbstractFlowNodeBuilder<?, ?> builder, String taskId) {
        if (this.createdTasks.contains(taskId)) {
            builder.connectTo(taskId);
        } else {
            YamlTask task = this.tasksById.get(taskId);
            if (task == null) {
                throw new RuntimeException(String.format("Expected to add task with id '%s', but no task definition with that id exists", taskId));
            }
            builder = this.addServiceTask((AbstractFlowNodeBuilder<?, ?>)builder, task);
            this.createdTasks.add(taskId);
            this.addFlowFromTask((AbstractFlowNodeBuilder<?, ?>)builder, task);
        }
    }

    private void addFlowFromTask(AbstractFlowNodeBuilder<?, ?> builder, YamlTask task) {
        if (!task.getCases().isEmpty()) {
            String gatewayId = "split-" + task.getId();
            ExclusiveGatewayBuilder gatewayBuilder = builder.exclusiveGateway(gatewayId);
            for (YamlCase flow : task.getCases()) {
                if (flow.getDefaultCase() != null) {
                    gatewayBuilder.defaultFlow();
                    this.addTask((AbstractFlowNodeBuilder<?, ?>)gatewayBuilder, flow.getDefaultCase());
                    continue;
                }
                gatewayBuilder.condition(flow.getCondition());
                this.addTask((AbstractFlowNodeBuilder<?, ?>)gatewayBuilder, flow.getNext());
            }
        } else if (task.getNext() != null) {
            this.addTask(builder, task.getNext());
        } else {
            YamlTask nextTask = this.getNextTask(task);
            if (!task.isEnd() && nextTask != null) {
                this.addTask(builder, nextTask.getId());
            } else {
                builder.endEvent();
            }
        }
    }

    private YamlTask getNextTask(YamlTask task) {
        List<YamlTask> tasks = this.definition.getTasks();
        int index = tasks.indexOf(task);
        if (index + 1 < tasks.size()) {
            return tasks.get(index + 1);
        }
        return null;
    }

    private ServiceTaskBuilder addServiceTask(AbstractFlowNodeBuilder<?, ?> builder, YamlTask task) {
        String id = task.getId();
        String taskType = task.getType();
        int taskRetries = task.getRetries();
        ServiceTaskBuilder serviceTaskBuilder = (ServiceTaskBuilder)((ServiceTaskBuilder)builder.serviceTask(id).zeebeTaskType(taskType)).zeebeTaskRetries(taskRetries);
        for (Map.Entry<String, String> header : task.getHeaders().entrySet()) {
            serviceTaskBuilder.zeebeTaskHeader(header.getKey(), header.getValue());
        }
        this.addInputOutputMappingToTask(task, serviceTaskBuilder);
        return serviceTaskBuilder;
    }

    private void addInputOutputMappingToTask(YamlTask task, ServiceTaskBuilder serviceTaskBuilder) {
        for (YamlMapping inputMapping : task.getInputs()) {
            serviceTaskBuilder.zeebeInput(inputMapping.getSource(), inputMapping.getTarget());
        }
        for (YamlMapping outputMapping : task.getOutputs()) {
            serviceTaskBuilder.zeebeOutput(outputMapping.getSource(), outputMapping.getTarget());
        }
    }
}

