/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.transform;

import io.zeebe.engine.processor.workflow.deployment.model.validation.ZeebeRuntimeValidators;
import io.zeebe.engine.processor.workflow.deployment.transform.ValidationErrorFormatter;
import io.zeebe.model.bpmn.BpmnModelInstance;
import io.zeebe.model.bpmn.traversal.ModelElementVisitor;
import io.zeebe.model.bpmn.traversal.ModelWalker;
import io.zeebe.model.bpmn.validation.ValidationVisitor;
import io.zeebe.model.bpmn.validation.zeebe.ZeebeDesignTimeValidators;
import java.io.StringWriter;
import org.camunda.bpm.model.xml.validation.ValidationResultFormatter;
import org.camunda.bpm.model.xml.validation.ValidationResults;

public class BpmnValidator {
    private final ValidationVisitor designTimeAspectValidator;
    private final ValidationVisitor runtimeAspectValidator;
    private final ValidationErrorFormatter formatter = new ValidationErrorFormatter();

    public BpmnValidator() {
        this.designTimeAspectValidator = new ValidationVisitor(ZeebeDesignTimeValidators.VALIDATORS);
        this.runtimeAspectValidator = new ValidationVisitor(ZeebeRuntimeValidators.VALIDATORS);
    }

    public String validate(BpmnModelInstance modelInstance) {
        this.designTimeAspectValidator.reset();
        this.runtimeAspectValidator.reset();
        ModelWalker walker = new ModelWalker(modelInstance);
        walker.walk((ModelElementVisitor)this.designTimeAspectValidator);
        walker.walk((ModelElementVisitor)this.runtimeAspectValidator);
        ValidationResults results1 = this.designTimeAspectValidator.getValidationResult();
        ValidationResults results2 = this.runtimeAspectValidator.getValidationResult();
        if (results1.hasErrors() || results2.hasErrors()) {
            StringWriter writer = new StringWriter();
            results1.write(writer, (ValidationResultFormatter)this.formatter);
            results2.write(writer, (ValidationResultFormatter)this.formatter);
            return writer.toString();
        }
        return null;
    }
}

