/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.deployment.transform;

import io.zeebe.engine.Loggers;
import io.zeebe.engine.processor.KeyGenerator;
import io.zeebe.engine.processor.workflow.deployment.model.yaml.BpmnYamlParser;
import io.zeebe.engine.processor.workflow.deployment.transform.BpmnValidator;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.model.bpmn.Bpmn;
import io.zeebe.model.bpmn.BpmnModelInstance;
import io.zeebe.model.bpmn.instance.Process;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.zeebe.protocol.impl.record.value.deployment.Workflow;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.value.deployment.ResourceType;
import io.zeebe.util.buffer.BufferUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.io.DirectBufferInputStream;
import org.slf4j.Logger;

public class DeploymentTransformer {
    private static final Logger LOG = Loggers.WORKFLOW_PROCESSOR_LOGGER;
    private final BpmnValidator validator = new BpmnValidator();
    private final BpmnYamlParser yamlParser = new BpmnYamlParser();
    private final WorkflowState workflowState;
    private final KeyGenerator keyGenerator;
    private RejectionType rejectionType;
    private String rejectionReason;

    public DeploymentTransformer(ZeebeState zeebeState) {
        this.workflowState = zeebeState.getWorkflowState();
        this.keyGenerator = zeebeState.getKeyGenerator();
    }

    public boolean transform(DeploymentRecord deploymentEvent) {
        StringBuilder validationErrors = new StringBuilder();
        boolean success = true;
        Iterator resourceIterator = deploymentEvent.resources().iterator();
        if (!resourceIterator.hasNext()) {
            this.rejectionType = RejectionType.INVALID_ARGUMENT;
            this.rejectionReason = "Expected to deploy at least one resource, but none given";
            return false;
        }
        while (resourceIterator.hasNext()) {
            DeploymentResource deploymentResource = (DeploymentResource)resourceIterator.next();
            success &= this.transformResource(deploymentEvent, validationErrors, deploymentResource);
        }
        if (!success) {
            this.rejectionType = RejectionType.INVALID_ARGUMENT;
            this.rejectionReason = String.format("Expected to deploy new resources, but encountered the following validation errors:%s", validationErrors.toString());
        }
        return success;
    }

    private boolean transformResource(DeploymentRecord deploymentEvent, StringBuilder validationErrors, DeploymentResource deploymentResource) {
        boolean success = true;
        try {
            BpmnModelInstance definition = this.readWorkflowDefinition(deploymentResource);
            String validationError = this.validator.validate(definition);
            if (validationError == null) {
                this.transformWorkflowResource(deploymentEvent, deploymentResource, definition);
            } else {
                validationErrors.append("\n'").append(BufferUtil.bufferAsString((DirectBuffer)deploymentResource.getResourceNameBuffer())).append("': ").append(validationError);
                success = false;
            }
        }
        catch (RuntimeException e) {
            String resourceName = BufferUtil.bufferAsString((DirectBuffer)deploymentResource.getResourceNameBuffer());
            LOG.error("Unexpected error while processing resource '{}'", (Object)resourceName, (Object)e);
            validationErrors.append("\n'").append(resourceName).append("': ").append(e.getMessage());
            success = false;
        }
        return success;
    }

    private void transformWorkflowResource(DeploymentRecord deploymentEvent, DeploymentResource deploymentResource, BpmnModelInstance definition) {
        Collection processes = definition.getDefinitions().getChildElementsByType(Process.class);
        for (Process workflow : processes) {
            if (!workflow.isExecutable()) continue;
            String bpmnProcessId = workflow.getId();
            long key = this.keyGenerator.nextKey();
            int version = this.workflowState.getNextWorkflowVersion(bpmnProcessId);
            ((Workflow)deploymentEvent.workflows().add()).setBpmnProcessId(BufferUtil.wrapString((String)workflow.getId())).setVersion(version).setKey(key).setResourceName(deploymentResource.getResourceNameBuffer());
        }
        this.transformYamlWorkflowResource(deploymentResource, definition);
    }

    private BpmnModelInstance readWorkflowDefinition(DeploymentResource deploymentResource) {
        DirectBuffer resource = deploymentResource.getResourceBuffer();
        DirectBufferInputStream resourceStream = new DirectBufferInputStream(resource);
        switch (deploymentResource.getResourceType()) {
            case YAML_WORKFLOW: {
                return this.yamlParser.readFromStream((InputStream)resourceStream);
            }
        }
        return Bpmn.readModelFromStream((InputStream)resourceStream);
    }

    private void transformYamlWorkflowResource(DeploymentResource deploymentResource, BpmnModelInstance definition) {
        if (deploymentResource.getResourceType() != ResourceType.BPMN_XML) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            Bpmn.writeModelToStream((OutputStream)outStream, (BpmnModelInstance)definition);
            MutableDirectBuffer bpmnXml = BufferUtil.wrapArray((byte[])outStream.toByteArray());
            deploymentResource.setResource((DirectBuffer)bpmnXml);
        }
    }

    public RejectionType getRejectionType() {
        return this.rejectionType;
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }
}

