/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers;

import io.zeebe.engine.Loggers;
import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.BpmnStepHandler;
import io.zeebe.engine.processor.workflow.WorkflowInstanceLifecycle;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowElement;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;

public abstract class AbstractHandler<T extends ExecutableFlowElement>
implements BpmnStepHandler<T> {
    private final WorkflowInstanceIntent nextState;

    public AbstractHandler(WorkflowInstanceIntent nextState) {
        this.nextState = nextState;
    }

    @Override
    public void handle(BpmnStepContext<T> context) {
        if (this.shouldHandleState(context)) {
            boolean handled = this.handleState(context);
            if (handled && this.shouldTransition()) {
                this.transitionToNext(context);
            }
        } else {
            Loggers.WORKFLOW_PROCESSOR_LOGGER.debug("Skipping record {} due to step guard; in-memory element is {}", (Object)context.getValue(), (Object)context.getElementInstance());
        }
    }

    protected abstract boolean handleState(BpmnStepContext<T> var1);

    protected boolean shouldHandleState(BpmnStepContext<T> context) {
        return true;
    }

    protected boolean isRootScope(BpmnStepContext<T> context) {
        return context.getValue().getFlowScopeKey() == -1L;
    }

    protected boolean isStateSameAsElementState(BpmnStepContext<T> context) {
        return context.getElementInstance() != null && context.getState() == context.getElementInstance().getState();
    }

    protected boolean isElementActive(ElementInstance instance) {
        return instance != null && instance.isActive();
    }

    protected boolean isElementTerminating(ElementInstance instance) {
        return instance != null && instance.isTerminating();
    }

    protected boolean shouldTransition() {
        return this.nextState != null;
    }

    protected void transitionToNext(BpmnStepContext<T> context) {
        this.transitionTo(context, this.nextState);
    }

    protected void transitionTo(BpmnStepContext<T> context, WorkflowInstanceIntent nextState) {
        ElementInstance elementInstance = context.getElementInstance();
        WorkflowInstanceIntent state = elementInstance.getState();
        assert (WorkflowInstanceLifecycle.canTransition(state, nextState)) : String.format("cannot transition from '%s' to '%s'", state, nextState);
        elementInstance.setState(nextState);
        context.getOutput().appendFollowUpEvent(context.getKey(), nextState, context.getValue());
        if (nextState == WorkflowInstanceIntent.ELEMENT_COMPLETING || nextState == WorkflowInstanceIntent.ELEMENT_TERMINATING) {
            context.getStateDb().getEventScopeInstanceState().shutdownInstance(context.getKey());
        }
        context.getElementInstanceState().updateInstance(elementInstance);
    }
}

