/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers;

import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowElement;
import io.zeebe.engine.processor.workflow.handlers.AbstractHandler;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.IndexedRecord;
import java.util.List;

public class AbstractTerminalStateHandler<T extends ExecutableFlowElement>
extends AbstractHandler<T> {
    public AbstractTerminalStateHandler() {
        super(null);
    }

    @Override
    public void handle(BpmnStepContext<T> context) {
        super.handle(context);
        context.getStateDb().getEventScopeInstanceState().deleteInstance(context.getKey());
        context.getElementInstanceState().removeInstance(context.getKey());
    }

    @Override
    protected boolean handleState(BpmnStepContext<T> context) {
        ElementInstance flowScopeInstance = context.getFlowScopeInstance();
        if (flowScopeInstance != null) {
            flowScopeInstance.consumeToken();
            context.getStateDb().getElementInstanceState().updateInstance(flowScopeInstance);
        }
        return true;
    }

    protected void publishDeferredRecords(BpmnStepContext<T> context) {
        List<IndexedRecord> deferredRecords = context.getElementInstanceState().getDeferredRecords(context.getKey());
        ElementInstance flowScopeInstance = context.getFlowScopeInstance();
        for (IndexedRecord record : deferredRecords) {
            record.getValue().setFlowScopeKey(flowScopeInstance.getKey());
            context.getOutput().appendFollowUpEvent(record.getKey(), record.getState(), record.getValue());
            flowScopeInstance.spawnToken();
        }
        context.getStateDb().getElementInstanceState().updateInstance(flowScopeInstance);
    }

    protected boolean isLastActiveExecutionPathInScope(BpmnStepContext<T> context) {
        ElementInstance flowScopeInstance = context.getFlowScopeInstance();
        if (flowScopeInstance == null) {
            return false;
        }
        int activePaths = flowScopeInstance.getNumberOfActiveTokens();
        assert (activePaths >= 0) : "number of active paths should never be negative";
        return activePaths == 1;
    }
}

