/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers;

import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.CatchEventBehavior;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableCatchEventSupplier;
import io.zeebe.engine.processor.workflow.message.MessageCorrelationKeyException;
import io.zeebe.protocol.record.value.ErrorType;

public class CatchEventSubscriber {
    private final CatchEventBehavior catchEventBehavior;

    public CatchEventSubscriber(CatchEventBehavior catchEventBehavior) {
        this.catchEventBehavior = catchEventBehavior;
    }

    public <T extends ExecutableCatchEventSupplier> boolean subscribeToEvents(BpmnStepContext<T> context) {
        try {
            this.catchEventBehavior.subscribeToEvents(context, (ExecutableCatchEventSupplier)context.getElement());
            return true;
        }
        catch (MessageCorrelationKeyException e) {
            context.raiseIncident(ErrorType.EXTRACT_VALUE_ERROR, e.getContext().getVariablesScopeKey(), e.getMessage());
            return false;
        }
    }

    public <T extends ExecutableCatchEventSupplier> void unsubscribeFromEvents(BpmnStepContext<T> context) {
        this.catchEventBehavior.unsubscribeFromEvents(context.getKey(), context);
    }
}

