/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers;

import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowNode;
import io.zeebe.engine.state.instance.VariablesState;
import io.zeebe.msgpack.mapping.Mapping;
import io.zeebe.msgpack.mapping.MsgPackMergeTool;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import java.util.HashSet;
import org.agrona.DirectBuffer;

public class IOMappingHelper {
    public <T extends ExecutableFlowNode> void applyOutputMappings(BpmnStepContext<T> context) {
        VariablesState variablesState = context.getElementInstanceState().getVariablesState();
        MsgPackMergeTool mergeTool = context.getMergeTool();
        ExecutableFlowNode element = (ExecutableFlowNode)context.getElement();
        WorkflowInstanceRecord record = context.getValue();
        long elementInstanceKey = context.getKey();
        long flowScopeKey = record.getFlowScopeKey();
        long workflowKey = record.getWorkflowKey();
        Mapping[] outputMappings = element.getOutputMappings();
        boolean hasOutputMappings = outputMappings.length > 0;
        DirectBuffer temporaryVariables = variablesState.getTemporaryVariables(elementInstanceKey);
        if (temporaryVariables != null) {
            if (hasOutputMappings) {
                variablesState.setVariablesLocalFromDocument(elementInstanceKey, workflowKey, temporaryVariables);
            } else {
                variablesState.setVariablesFromDocument(elementInstanceKey, workflowKey, temporaryVariables);
            }
            variablesState.removeTemporaryVariables(elementInstanceKey);
        }
        if (hasOutputMappings) {
            mergeTool.reset();
            DirectBuffer variables = this.determineVariables(variablesState, elementInstanceKey, outputMappings);
            mergeTool.mergeDocumentStrictly(variables, outputMappings);
            DirectBuffer mergedVariables = mergeTool.writeResultToBuffer();
            variablesState.setVariablesFromDocument(flowScopeKey, workflowKey, mergedVariables);
        }
    }

    public <T extends ExecutableFlowNode> void applyInputMappings(BpmnStepContext<T> context) {
        MsgPackMergeTool mergeTool = context.getMergeTool();
        ExecutableFlowNode element = (ExecutableFlowNode)context.getElement();
        Mapping[] mappings = element.getInputMappings();
        if (mappings.length > 0) {
            mergeTool.reset();
            VariablesState variablesState = context.getElementInstanceState().getVariablesState();
            DirectBuffer scopeVariables = this.determineVariables(variablesState, context.getFlowScopeInstance().getKey(), mappings);
            mergeTool.mergeDocumentStrictly(scopeVariables, mappings);
            DirectBuffer mappedVariables = mergeTool.writeResultToBuffer();
            long scopeKey = context.getKey();
            long workflowKey = context.getValue().getWorkflowKey();
            context.getElementInstanceState().getVariablesState().setVariablesLocalFromDocument(scopeKey, workflowKey, mappedVariables);
        }
    }

    private DirectBuffer determineVariables(VariablesState variablesState, long elementInstanceKey, Mapping[] outputMappings) {
        HashSet<DirectBuffer> variableNames = new HashSet<DirectBuffer>();
        for (Mapping m : outputMappings) {
            variableNames.add(m.getSource().getVariableName());
        }
        return variablesState.getVariablesAsDocument(elementInstanceKey, variableNames);
    }
}

