/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers.activity;

import io.zeebe.engine.Loggers;
import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableActivity;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableBoundaryEvent;
import io.zeebe.engine.processor.workflow.handlers.element.EventOccurredHandler;
import io.zeebe.engine.state.instance.EventTrigger;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.util.buffer.BufferUtil;
import java.util.List;
import org.agrona.DirectBuffer;

public class ActivityEventOccurredHandler<T extends ExecutableActivity>
extends EventOccurredHandler<T> {
    public ActivityEventOccurredHandler() {
        this(null);
    }

    public ActivityEventOccurredHandler(WorkflowInstanceIntent nextState) {
        super(nextState);
    }

    @Override
    protected boolean handleState(BpmnStepContext<T> context) {
        EventTrigger event = this.getTriggeredEvent(context, context.getKey());
        ExecutableBoundaryEvent boundaryEvent = this.getBoundaryEvent(context, event);
        if (boundaryEvent == null) {
            Loggers.WORKFLOW_PROCESSOR_LOGGER.error("No boundary event found with ID {} for process {}", (Object)BufferUtil.bufferAsString((DirectBuffer)event.getElementId()), (Object)BufferUtil.bufferAsString((DirectBuffer)context.getValue().getBpmnProcessIdBuffer()));
            return false;
        }
        WorkflowInstanceRecord eventRecord = this.getEventRecord(context, event, boundaryEvent.getElementType());
        if (boundaryEvent.cancelActivity()) {
            this.transitionTo(context, WorkflowInstanceIntent.ELEMENT_TERMINATING);
            this.deferEvent(context, context.getKey(), context.getKey(), eventRecord, event);
        } else {
            this.publishEvent(context, context.getKey(), eventRecord, event);
        }
        return true;
    }

    private ExecutableBoundaryEvent getBoundaryEvent(BpmnStepContext<T> context, EventTrigger event) {
        List<ExecutableBoundaryEvent> boundaryEvents = ((ExecutableActivity)context.getElement()).getBoundaryEvents();
        for (ExecutableBoundaryEvent boundaryEvent : boundaryEvents) {
            if (!event.getElementId().equals(boundaryEvent.getId())) continue;
            return boundaryEvent;
        }
        return null;
    }
}

