/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers.container;

import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableCatchEventElement;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowElementContainer;
import io.zeebe.engine.processor.workflow.handlers.element.ElementActivatedHandler;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.IndexedRecord;
import io.zeebe.engine.state.instance.StoredRecord;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import java.util.List;

public class ContainerElementActivatedHandler<T extends ExecutableFlowElementContainer>
extends ElementActivatedHandler<T> {
    private final WorkflowState workflowState;

    public ContainerElementActivatedHandler(WorkflowState workflowState) {
        this(null, workflowState);
    }

    public ContainerElementActivatedHandler(WorkflowInstanceIntent nextState, WorkflowState workflowState) {
        super(nextState);
        this.workflowState = workflowState;
    }

    @Override
    protected boolean handleState(BpmnStepContext<T> context) {
        if (!super.handleState(context)) {
            return false;
        }
        ExecutableFlowElementContainer element = (ExecutableFlowElementContainer)context.getElement();
        ExecutableCatchEventElement firstStartEvent = element.getStartEvents().get(0);
        if (firstStartEvent.isNone()) {
            this.activateNoneStartEvent(context, firstStartEvent);
        } else {
            this.publishDeferredRecord(context);
        }
        ElementInstance elementInstance = context.getElementInstance();
        elementInstance.spawnToken();
        context.getStateDb().getElementInstanceState().updateInstance(elementInstance);
        return true;
    }

    private void publishDeferredRecord(BpmnStepContext<T> context) {
        IndexedRecord deferredRecord = this.getDeferredRecord(context);
        context.getOutput().appendFollowUpEvent(deferredRecord.getKey(), deferredRecord.getState(), deferredRecord.getValue());
    }

    private void activateNoneStartEvent(BpmnStepContext<T> context, ExecutableCatchEventElement firstStartEvent) {
        WorkflowInstanceRecord value = context.getValue();
        value.setElementId(firstStartEvent.getId());
        value.setBpmnElementType(firstStartEvent.getElementType());
        value.setFlowScopeKey(context.getKey());
        context.getOutput().appendNewEvent(WorkflowInstanceIntent.ELEMENT_ACTIVATING, value);
    }

    private IndexedRecord getDeferredRecord(BpmnStepContext<T> context) {
        long wfInstanceKey = context.getValue().getWorkflowInstanceKey();
        List<IndexedRecord> deferredRecords = context.getElementInstanceState().getDeferredRecords(wfInstanceKey);
        if (deferredRecords.isEmpty()) {
            throw new IllegalStateException("Expected process with no none start events to have a deferred record, but nothing was found");
        }
        assert (deferredRecords.size() == 1) : "should only have one deferred start event per workflow instance";
        IndexedRecord deferredRecord = deferredRecords.get(0);
        this.workflowState.getElementInstanceState().removeStoredRecord(wfInstanceKey, deferredRecord.getKey(), StoredRecord.Purpose.DEFERRED);
        return deferredRecord;
    }
}

