/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers.container;

import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.EventOutput;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowElementContainer;
import io.zeebe.engine.processor.workflow.handlers.CatchEventSubscriber;
import io.zeebe.engine.processor.workflow.handlers.activity.ActivityElementTerminatingHandler;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.ElementInstanceState;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import java.util.List;

public class ContainerElementTerminatingHandler<T extends ExecutableFlowElementContainer>
extends ActivityElementTerminatingHandler<T> {
    public ContainerElementTerminatingHandler(CatchEventSubscriber catchEventSubscriber) {
        this(null, catchEventSubscriber);
    }

    public ContainerElementTerminatingHandler(WorkflowInstanceIntent nextState, CatchEventSubscriber catchEventSubscriber) {
        super(nextState, catchEventSubscriber);
    }

    @Override
    protected boolean handleState(BpmnStepContext<T> context) {
        if (!super.handleState(context)) {
            return false;
        }
        ElementInstance elementInstance = context.getElementInstance();
        EventOutput output = context.getOutput();
        ElementInstanceState elementInstanceState = context.getElementInstanceState();
        List<ElementInstance> children = elementInstanceState.getChildren(elementInstance.getKey());
        if (children.isEmpty()) {
            this.transitionTo(context, WorkflowInstanceIntent.ELEMENT_TERMINATED);
        } else {
            for (ElementInstance child : children) {
                if (!child.canTerminate()) continue;
                output.appendFollowUpEvent(child.getKey(), WorkflowInstanceIntent.ELEMENT_TERMINATING, child.getValue());
            }
        }
        return true;
    }
}

