/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers.element;

import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowNode;
import io.zeebe.engine.processor.workflow.handlers.AbstractHandler;
import io.zeebe.engine.processor.workflow.handlers.IOMappingHelper;
import io.zeebe.msgpack.mapping.MappingException;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.protocol.record.value.ErrorType;

public class ElementActivatingHandler<T extends ExecutableFlowNode>
extends AbstractHandler<T> {
    private final IOMappingHelper ioMappingHelper;

    public ElementActivatingHandler() {
        this(WorkflowInstanceIntent.ELEMENT_ACTIVATED);
    }

    public ElementActivatingHandler(WorkflowInstanceIntent nextState) {
        this(nextState, new IOMappingHelper());
    }

    public ElementActivatingHandler(WorkflowInstanceIntent nextState, IOMappingHelper ioMappingHelper) {
        super(nextState);
        this.ioMappingHelper = ioMappingHelper;
    }

    @Override
    protected boolean shouldHandleState(BpmnStepContext<T> context) {
        return super.shouldHandleState(context) && this.isStateSameAsElementState(context) && (this.isRootScope(context) || this.isElementActive(context.getFlowScopeInstance()));
    }

    @Override
    protected boolean handleState(BpmnStepContext<T> context) {
        try {
            this.ioMappingHelper.applyInputMappings(context);
            return true;
        }
        catch (MappingException e) {
            context.raiseIncident(ErrorType.IO_MAPPING_ERROR, e.getMessage());
            return false;
        }
    }
}

