/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers.element;

import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowNode;
import io.zeebe.engine.processor.workflow.handlers.AbstractTerminalStateHandler;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;

public class ElementCompletedHandler<T extends ExecutableFlowNode>
extends AbstractTerminalStateHandler<T> {
    @Override
    protected boolean shouldHandleState(BpmnStepContext<T> context) {
        return super.shouldHandleState(context) && this.isStateSameAsElementState(context) && (this.isRootScope(context) || this.isElementActive(context.getFlowScopeInstance()));
    }

    @Override
    protected boolean handleState(BpmnStepContext<T> context) {
        if (this.isLastActiveExecutionPathInScope(context)) {
            this.completeFlowScope(context);
        }
        return super.handleState(context);
    }

    protected void completeFlowScope(BpmnStepContext<T> context) {
        ElementInstance flowScopeInstance = context.getFlowScopeInstance();
        WorkflowInstanceRecord flowScopeInstanceValue = flowScopeInstance.getValue();
        context.getOutput().appendFollowUpEvent(flowScopeInstance.getKey(), WorkflowInstanceIntent.ELEMENT_COMPLETING, flowScopeInstanceValue);
    }
}

