/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers.element;

import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.WorkflowInstanceLifecycle;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowNode;
import io.zeebe.engine.processor.workflow.handlers.AbstractTerminalStateHandler;
import io.zeebe.engine.processor.workflow.handlers.IncidentResolver;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;

public class ElementTerminatedHandler<T extends ExecutableFlowNode>
extends AbstractTerminalStateHandler<T> {
    private final IncidentResolver incidentResolver;

    public ElementTerminatedHandler(IncidentResolver incidentResolver) {
        this.incidentResolver = incidentResolver;
    }

    @Override
    protected boolean shouldHandleState(BpmnStepContext<T> context) {
        return super.shouldHandleState(context) && this.isStateSameAsElementState(context);
    }

    @Override
    protected boolean handleState(BpmnStepContext<T> context) {
        ElementInstance flowScopeInstance = context.getFlowScopeInstance();
        boolean isScopeTerminating = flowScopeInstance != null && WorkflowInstanceLifecycle.canTransition(flowScopeInstance.getState(), WorkflowInstanceIntent.ELEMENT_TERMINATED);
        this.incidentResolver.resolveIncidents(context);
        if (isScopeTerminating && this.isLastActiveExecutionPathInScope(context)) {
            context.getOutput().appendFollowUpEvent(flowScopeInstance.getKey(), WorkflowInstanceIntent.ELEMENT_TERMINATED, flowScopeInstance.getValue());
        }
        return super.handleState(context);
    }
}

