/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers.element;

import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowElement;
import io.zeebe.engine.processor.workflow.handlers.AbstractHandler;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.EventTrigger;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;

public class EventOccurredHandler<T extends ExecutableFlowElement>
extends AbstractHandler<T> {
    private final WorkflowInstanceRecord eventRecord = new WorkflowInstanceRecord();

    public EventOccurredHandler() {
        this(WorkflowInstanceIntent.ELEMENT_COMPLETING);
    }

    public EventOccurredHandler(WorkflowInstanceIntent nextState) {
        super(nextState);
    }

    @Override
    protected boolean shouldHandleState(BpmnStepContext<T> context) {
        return super.shouldHandleState(context) && (!this.hasWorkflowInstance(context) || this.isElementActive(context.getElementInstance()));
    }

    @Override
    protected boolean handleState(BpmnStepContext<T> context) {
        return true;
    }

    protected EventTrigger getTriggeredEvent(BpmnStepContext<T> context, long scopeKey) {
        return context.getStateDb().getEventScopeInstanceState().peekEventTrigger(scopeKey);
    }

    protected long deferEvent(BpmnStepContext<T> context, long eventScopeKey, long flowScopeKey, WorkflowInstanceRecord record, EventTrigger event) {
        long eventInstanceKey = context.getOutput().deferRecord(flowScopeKey, record, WorkflowInstanceIntent.ELEMENT_ACTIVATING);
        this.processEventTrigger(context, eventScopeKey, eventInstanceKey, event);
        return eventInstanceKey;
    }

    protected long publishEvent(BpmnStepContext<T> context, long eventScopeKey, WorkflowInstanceRecord record, EventTrigger event) {
        long eventInstanceKey = context.getOutput().appendNewEvent(WorkflowInstanceIntent.ELEMENT_ACTIVATING, record);
        this.processEventTrigger(context, eventScopeKey, eventInstanceKey, event);
        ElementInstance flowScopeInstance = context.getFlowScopeInstance();
        flowScopeInstance.spawnToken();
        context.getStateDb().getElementInstanceState().updateInstance(flowScopeInstance);
        return eventInstanceKey;
    }

    protected void processEventTrigger(BpmnStepContext<T> context, long eventScopeKey, long variableScopeKey, EventTrigger event) {
        context.getElementInstanceState().getVariablesState().setTemporaryVariables(variableScopeKey, event.getVariables());
        context.getStateDb().getEventScopeInstanceState().deleteTrigger(eventScopeKey, event.getEventKey());
    }

    protected WorkflowInstanceRecord getEventRecord(BpmnStepContext<T> context, EventTrigger event, BpmnElementType elementType) {
        this.eventRecord.reset();
        this.eventRecord.wrap(context.getValue());
        this.eventRecord.setElementId(event.getElementId());
        this.eventRecord.setBpmnElementType(elementType);
        return this.eventRecord;
    }

    private boolean hasWorkflowInstance(BpmnStepContext<T> context) {
        return context.getValue().getWorkflowInstanceKey() >= 0L;
    }
}

