/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers.gateway;

import io.zeebe.engine.Loggers;
import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableEventBasedGateway;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableSequenceFlow;
import io.zeebe.engine.processor.workflow.handlers.element.EventOccurredHandler;
import io.zeebe.engine.state.instance.EventTrigger;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.util.buffer.BufferUtil;
import java.util.List;
import org.agrona.DirectBuffer;

public class EventBasedGatewayEventOccurredHandler<T extends ExecutableEventBasedGateway>
extends EventOccurredHandler<T> {
    public EventBasedGatewayEventOccurredHandler() {
    }

    public EventBasedGatewayEventOccurredHandler(WorkflowInstanceIntent nextState) {
        super(nextState);
    }

    @Override
    protected boolean handleState(BpmnStepContext<T> context) {
        if (super.handleState(context)) {
            EventTrigger event = this.getTriggeredEvent(context, context.getKey());
            ExecutableSequenceFlow flow = this.getSequenceFlow(context, event);
            if (flow == null) {
                Loggers.WORKFLOW_PROCESSOR_LOGGER.error("No outgoing flow has a target with ID {} for process {}", (Object)BufferUtil.bufferAsString((DirectBuffer)event.getElementId()), (Object)BufferUtil.bufferAsString((DirectBuffer)context.getValue().getBpmnProcessIdBuffer()));
                return false;
            }
            WorkflowInstanceRecord eventRecord = this.getEventRecord(context, event, flow.getTarget().getElementType());
            this.deferEvent(context, context.getKey(), context.getKey(), eventRecord, event);
            return true;
        }
        return false;
    }

    private ExecutableSequenceFlow getSequenceFlow(BpmnStepContext<T> context, EventTrigger event) {
        List<ExecutableSequenceFlow> outgoing = ((ExecutableEventBasedGateway)context.getElement()).getOutgoing();
        for (ExecutableSequenceFlow flow : outgoing) {
            if (!flow.getTarget().getId().equals(event.getElementId())) continue;
            return flow;
        }
        return null;
    }
}

