/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers.gateway;

import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableExclusiveGateway;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableSequenceFlow;
import io.zeebe.engine.processor.workflow.handlers.element.ElementActivatingHandler;
import io.zeebe.msgpack.el.CompiledJsonCondition;
import io.zeebe.msgpack.el.JsonConditionException;
import io.zeebe.msgpack.el.JsonConditionInterpreter;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;
import io.zeebe.protocol.record.value.ErrorType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.agrona.DirectBuffer;

public class ExclusiveGatewayElementActivatingHandler<T extends ExecutableExclusiveGateway>
extends ElementActivatingHandler<T> {
    private static final String NO_OUTGOING_FLOW_CHOSEN_ERROR = "Expected at least one condition to evaluate to true, or to have a default flow";
    private final WorkflowInstanceRecord record = new WorkflowInstanceRecord();
    private final JsonConditionInterpreter interpreter;

    public ExclusiveGatewayElementActivatingHandler() {
        this(new JsonConditionInterpreter());
    }

    public ExclusiveGatewayElementActivatingHandler(JsonConditionInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    protected boolean handleState(BpmnStepContext<T> context) {
        ExecutableSequenceFlow sequenceFlow;
        if (!super.handleState(context)) {
            return false;
        }
        WorkflowInstanceRecord value = context.getValue();
        try {
            ExecutableExclusiveGateway exclusiveGateway = (ExecutableExclusiveGateway)context.getElement();
            DirectBuffer variables = this.determineVariables(context, exclusiveGateway);
            sequenceFlow = this.getSequenceFlowWithFulfilledCondition(exclusiveGateway, variables);
        }
        catch (JsonConditionException e) {
            context.raiseIncident(ErrorType.CONDITION_ERROR, e.getMessage());
            return false;
        }
        if (sequenceFlow == null) {
            context.raiseIncident(ErrorType.CONDITION_ERROR, NO_OUTGOING_FLOW_CHOSEN_ERROR);
            return false;
        }
        this.deferSequenceFlowTaken(context, value, sequenceFlow);
        return true;
    }

    private DirectBuffer determineVariables(BpmnStepContext<T> context, ExecutableExclusiveGateway exclusiveGateway) {
        List<ExecutableSequenceFlow> sequenceFlows = exclusiveGateway.getOutgoingWithCondition();
        HashSet<DirectBuffer> actualNeededVariables = new HashSet<DirectBuffer>();
        for (ExecutableSequenceFlow seqFlow : sequenceFlows) {
            CompiledJsonCondition compiledCondition = seqFlow.getCondition();
            Set variableNames = compiledCondition.getVariableNames();
            actualNeededVariables.addAll(variableNames);
        }
        return context.getElementInstanceState().getVariablesState().getVariablesAsDocument(context.getKey(), actualNeededVariables);
    }

    private void deferSequenceFlowTaken(BpmnStepContext<T> context, WorkflowInstanceRecord value, ExecutableSequenceFlow sequenceFlow) {
        this.record.wrap(value);
        this.record.setElementId(sequenceFlow.getId());
        this.record.setBpmnElementType(BpmnElementType.SEQUENCE_FLOW);
        context.getOutput().deferRecord(context.getKey(), this.record, WorkflowInstanceIntent.SEQUENCE_FLOW_TAKEN);
    }

    private ExecutableSequenceFlow getSequenceFlowWithFulfilledCondition(ExecutableExclusiveGateway exclusiveGateway, DirectBuffer variables) {
        List<ExecutableSequenceFlow> sequenceFlows = exclusiveGateway.getOutgoingWithCondition();
        for (ExecutableSequenceFlow sequenceFlow : sequenceFlows) {
            CompiledJsonCondition compiledCondition = sequenceFlow.getCondition();
            boolean isFulFilled = this.interpreter.eval(compiledCondition, variables);
            if (!isFulFilled) continue;
            return sequenceFlow;
        }
        return exclusiveGateway.getDefaultFlow();
    }
}

