/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers.seqflow;

import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowNode;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableSequenceFlow;
import io.zeebe.engine.processor.workflow.handlers.element.ElementCompletedHandler;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import java.util.List;

public class FlowOutElementCompletedHandler<T extends ExecutableFlowNode>
extends ElementCompletedHandler<T> {
    @Override
    protected boolean handleState(BpmnStepContext<T> context) {
        List<ExecutableSequenceFlow> outgoing = ((ExecutableFlowNode)context.getElement()).getOutgoing();
        for (ExecutableSequenceFlow flow : outgoing) {
            this.takeSequenceFlow(context, flow);
        }
        return super.handleState(context);
    }

    private void takeSequenceFlow(BpmnStepContext<T> context, ExecutableSequenceFlow flow) {
        context.getOutput().appendNewEvent(WorkflowInstanceIntent.SEQUENCE_FLOW_TAKEN, context.getValue(), flow);
        ElementInstance flowScopeInstance = context.getFlowScopeInstance();
        flowScopeInstance.spawnToken();
        context.getStateDb().getElementInstanceState().updateInstance(flowScopeInstance);
    }
}

