/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers.seqflow;

import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.EventOutput;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowNode;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableSequenceFlow;
import io.zeebe.engine.processor.workflow.handlers.AbstractHandler;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.IndexedRecord;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import java.util.ArrayList;
import java.util.List;

public class ParallelMergeSequenceFlowTaken<T extends ExecutableSequenceFlow>
extends AbstractHandler<T> {
    public ParallelMergeSequenceFlowTaken() {
        super(null);
    }

    @Override
    protected boolean shouldHandleState(BpmnStepContext<T> context) {
        return super.shouldHandleState(context) && this.isElementActive(context.getFlowScopeInstance());
    }

    @Override
    protected boolean handleState(BpmnStepContext<T> context) {
        ElementInstance scopeInstance = context.getFlowScopeInstance();
        EventOutput eventOutput = context.getOutput();
        ExecutableSequenceFlow sequenceFlow = (ExecutableSequenceFlow)context.getElement();
        ExecutableFlowNode gateway = sequenceFlow.getTarget();
        eventOutput.deferEvent(context.getState(), context.getValue());
        List<IndexedRecord> mergeableRecords = this.getMergeableRecords(context, gateway, scopeInstance);
        if (mergeableRecords.size() == gateway.getIncoming().size()) {
            mergeableRecords.forEach(r -> {
                eventOutput.removeDeferredEvent(scopeInstance.getKey(), r.getKey());
                scopeInstance.consumeToken();
            });
            context.getOutput().appendNewEvent(WorkflowInstanceIntent.ELEMENT_ACTIVATING, context.getValue(), gateway);
            scopeInstance.spawnToken();
            context.getStateDb().getElementInstanceState().updateInstance(scopeInstance);
        }
        return true;
    }

    private List<IndexedRecord> getMergeableRecords(BpmnStepContext<T> context, ExecutableFlowNode parallelGateway, ElementInstance scopeInstance) {
        List<ExecutableSequenceFlow> incomingFlows = parallelGateway.getIncoming();
        ArrayList<IndexedRecord> mergingRecords = new ArrayList<IndexedRecord>(incomingFlows.size());
        List<IndexedRecord> storedRecords = context.getElementInstanceState().getDeferredRecords(scopeInstance.getKey());
        block0: for (ExecutableSequenceFlow flow : incomingFlows) {
            for (IndexedRecord recordToMatch : storedRecords) {
                if (!recordToMatch.getValue().getElementIdBuffer().equals(flow.getId())) continue;
                mergingRecords.add(recordToMatch);
                continue block0;
            }
        }
        return mergingRecords;
    }
}

