/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers.servicetask;

import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableServiceTask;
import io.zeebe.engine.processor.workflow.handlers.element.ElementActivatedHandler;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.msgpack.value.DocumentValue;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobIntent;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import org.agrona.DirectBuffer;

public class ServiceTaskElementActivatedHandler<T extends ExecutableServiceTask>
extends ElementActivatedHandler<T> {
    private final JobRecord jobCommand = new JobRecord();

    public ServiceTaskElementActivatedHandler() {
        this(null);
    }

    public ServiceTaskElementActivatedHandler(WorkflowInstanceIntent nextState) {
        super(nextState);
    }

    @Override
    protected boolean handleState(BpmnStepContext<T> context) {
        if (super.handleState(context)) {
            WorkflowInstanceRecord value = context.getValue();
            ExecutableServiceTask serviceTask = (ExecutableServiceTask)context.getElement();
            this.populateJobFromTask(context, value, serviceTask);
            context.getCommandWriter().appendNewCommand((Intent)JobIntent.CREATE, (UnpackedObject)this.jobCommand);
            return true;
        }
        return false;
    }

    private void populateJobFromTask(BpmnStepContext<T> context, WorkflowInstanceRecord value, ExecutableServiceTask serviceTask) {
        DirectBuffer headers = serviceTask.getEncodedHeaders();
        this.jobCommand.reset();
        this.jobCommand.setType(serviceTask.getType()).setRetries(serviceTask.getRetries()).setVariables(DocumentValue.EMPTY_DOCUMENT).setCustomHeaders(headers).getJobHeaders().setBpmnProcessId(value.getBpmnProcessIdBuffer()).setWorkflowDefinitionVersion(value.getVersion()).setWorkflowKey(value.getWorkflowKey()).setWorkflowInstanceKey(value.getWorkflowInstanceKey()).setElementId(serviceTask.getId()).setElementInstanceKey(context.getKey());
    }
}

