/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.handlers.servicetask;

import io.zeebe.engine.Loggers;
import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableServiceTask;
import io.zeebe.engine.processor.workflow.handlers.CatchEventSubscriber;
import io.zeebe.engine.processor.workflow.handlers.activity.ActivityElementTerminatingHandler;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.IncidentState;
import io.zeebe.engine.state.instance.JobState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobIntent;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;

public class ServiceTaskElementTerminatingHandler<T extends ExecutableServiceTask>
extends ActivityElementTerminatingHandler<T> {
    private final IncidentState incidentState;
    private final JobState jobState;

    public ServiceTaskElementTerminatingHandler(IncidentState incidentState, CatchEventSubscriber catchEventSubscriber, JobState jobState) {
        super(catchEventSubscriber);
        this.incidentState = incidentState;
        this.jobState = jobState;
    }

    public ServiceTaskElementTerminatingHandler(WorkflowInstanceIntent nextState, IncidentState incidentState, CatchEventSubscriber catchEventSubscriber, JobState jobState) {
        super(nextState, catchEventSubscriber);
        this.incidentState = incidentState;
        this.jobState = jobState;
    }

    @Override
    protected boolean handleState(BpmnStepContext<T> context) {
        if (!super.handleState(context)) {
            return false;
        }
        ElementInstance elementInstance = context.getElementInstance();
        long jobKey = elementInstance.getJobKey();
        if (jobKey > 0L) {
            JobRecord job = this.jobState.getJob(jobKey);
            if (job != null) {
                context.getCommandWriter().appendFollowUpCommand(jobKey, (Intent)JobIntent.CANCEL, (UnpackedObject)job);
            } else {
                Loggers.WORKFLOW_PROCESSOR_LOGGER.warn("Expected to find job with key {}, but no job found", (Object)jobKey);
            }
            this.resolveExistingJobIncident(jobKey, context);
        }
        return true;
    }

    private void resolveExistingJobIncident(long jobKey, BpmnStepContext<T> context) {
        boolean hasIncident;
        long jobIncidentKey = this.incidentState.getJobIncidentKey(jobKey);
        boolean bl = hasIncident = jobIncidentKey != -1L;
        if (hasIncident) {
            IncidentRecord incidentRecord = this.incidentState.getIncidentRecord(jobIncidentKey);
            context.getOutput().appendResolvedIncidentEvent(jobIncidentKey, incidentRecord);
        }
    }
}

