/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.incident;

import io.zeebe.engine.processor.CommandProcessor;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.engine.state.instance.ElementInstanceState;
import io.zeebe.engine.state.instance.IncidentState;
import io.zeebe.engine.state.instance.IndexedRecord;
import io.zeebe.engine.state.instance.JobState;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.IncidentIntent;
import io.zeebe.protocol.record.intent.Intent;

public final class CreateIncidentProcessor
implements CommandProcessor<IncidentRecord> {
    public static final String NO_FAILED_RECORD_MESSAGE = "Expected to create incident for failed record with key '%d', but no such record was found";
    public static final String JOB_NOT_FAILED_MESSAGE = "Expected to create incident for failed job with key '%d', but it is not failed";
    public static final String NO_FAILED_JOB_MESSAGE = "Expected to create incident for failed job with key '%d', but no such job was found";
    private final ZeebeState zeebeState;

    public CreateIncidentProcessor(ZeebeState zeebeState) {
        this.zeebeState = zeebeState;
    }

    @Override
    public void onCommand(TypedRecord<IncidentRecord> command, CommandProcessor.CommandControl<IncidentRecord> commandControl) {
        boolean incidentIsNotRejected;
        IncidentRecord incidentEvent = command.getValue();
        boolean bl = incidentIsNotRejected = !this.rejectIncidentCreation(incidentEvent, commandControl);
        if (incidentIsNotRejected) {
            long incidentKey = commandControl.accept((Intent)IncidentIntent.CREATED, incidentEvent);
            this.zeebeState.getIncidentState().createIncident(incidentKey, incidentEvent);
        }
    }

    public boolean rejectIncidentCreation(IncidentRecord incidentEvent, CommandProcessor.CommandControl<IncidentRecord> commandControl) {
        IncidentState incidentState = this.zeebeState.getIncidentState();
        boolean isJobIncident = incidentState.isJobIncident(incidentEvent);
        if (isJobIncident) {
            return this.rejectJobIncident(incidentEvent.getJobKey(), commandControl);
        }
        return this.rejectWorkflowInstanceIncident(incidentEvent.getElementInstanceKey(), commandControl);
    }

    private boolean rejectJobIncident(long jobKey, CommandProcessor.CommandControl<IncidentRecord> commandControl) {
        JobState state = this.zeebeState.getJobState();
        JobState.State jobState = state.getState(jobKey);
        if (jobState == JobState.State.NOT_FOUND) {
            commandControl.reject(RejectionType.NOT_FOUND, String.format(NO_FAILED_JOB_MESSAGE, jobKey));
        } else if (jobState != JobState.State.FAILED) {
            commandControl.reject(RejectionType.INVALID_STATE, String.format(JOB_NOT_FAILED_MESSAGE, jobKey));
        }
        return jobState != JobState.State.FAILED;
    }

    private boolean rejectWorkflowInstanceIncident(long elementInstanceKey, CommandProcessor.CommandControl<IncidentRecord> commandControl) {
        boolean noFailedRecord;
        ElementInstanceState elementInstanceState = this.zeebeState.getWorkflowState().getElementInstanceState();
        IndexedRecord failedRecord = elementInstanceState.getFailedRecord(elementInstanceKey);
        boolean bl = noFailedRecord = failedRecord == null;
        if (noFailedRecord) {
            commandControl.reject(RejectionType.NOT_FOUND, String.format(NO_FAILED_RECORD_MESSAGE, elementInstanceKey));
        }
        return noFailedRecord;
    }
}

