/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.incident;

import io.zeebe.engine.processor.SideEffectProducer;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.BpmnStepProcessor;
import io.zeebe.engine.processor.workflow.SideEffectQueue;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.engine.state.instance.IncidentState;
import io.zeebe.engine.state.instance.IndexedRecord;
import io.zeebe.engine.state.instance.JobState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.IncidentIntent;
import io.zeebe.protocol.record.intent.Intent;
import java.util.function.Consumer;

public final class ResolveIncidentProcessor
implements TypedRecordProcessor<IncidentRecord> {
    public static final String NO_INCIDENT_FOUND_MSG = "Expected to resolve incident with key '%d', but no such incident was found";
    private final BpmnStepProcessor stepProcessor;
    private final ZeebeState zeebeState;
    private final SideEffectQueue queue = new SideEffectQueue();

    public ResolveIncidentProcessor(BpmnStepProcessor stepProcessor, ZeebeState zeebeState) {
        this.stepProcessor = stepProcessor;
        this.zeebeState = zeebeState;
    }

    @Override
    public void processRecord(TypedRecord<IncidentRecord> command, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        long incidentKey = command.getKey();
        IncidentState incidentState = this.zeebeState.getIncidentState();
        IncidentRecord incidentRecord = incidentState.getIncidentRecord(incidentKey);
        if (incidentRecord != null) {
            incidentState.deleteIncident(incidentKey);
            streamWriter.appendFollowUpEvent(incidentKey, (Intent)IncidentIntent.RESOLVED, (UnpackedObject)incidentRecord);
            responseWriter.writeEventOnCommand(incidentKey, (Intent)IncidentIntent.RESOLVED, (UnpackedObject)incidentRecord, command);
            this.attemptToResolveIncident(responseWriter, streamWriter, sideEffect, incidentRecord);
        } else {
            this.rejectResolveCommand(command, responseWriter, streamWriter, incidentKey);
        }
    }

    private void rejectResolveCommand(TypedRecord<IncidentRecord> command, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, long incidentKey) {
        String errorMessage = String.format(NO_INCIDENT_FOUND_MSG, incidentKey);
        streamWriter.appendRejection(command, RejectionType.NOT_FOUND, errorMessage);
        responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, errorMessage);
    }

    private void attemptToResolveIncident(TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect, IncidentRecord incidentRecord) {
        boolean isJobIncident;
        long jobKey = incidentRecord.getJobKey();
        boolean bl = isJobIncident = jobKey > 0L;
        if (isJobIncident) {
            this.attemptToMakeJobActivatableAgain(jobKey);
        } else {
            this.attemptToContinueWorkflowProcessing(responseWriter, streamWriter, sideEffect, incidentRecord);
        }
    }

    private void attemptToContinueWorkflowProcessing(TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect, IncidentRecord incidentRecord) {
        long elementInstanceKey = incidentRecord.getElementInstanceKey();
        IndexedRecord failedRecord = this.zeebeState.getWorkflowState().getElementInstanceState().getFailedRecord(elementInstanceKey);
        if (failedRecord != null) {
            this.queue.clear();
            this.queue.add(responseWriter::flush);
            this.stepProcessor.processRecordValue(failedRecord.getKey(), failedRecord.getValue(), failedRecord.getState(), streamWriter, this.queue::add);
            sideEffect.accept(this.queue);
        }
    }

    private void attemptToMakeJobActivatableAgain(long jobKey) {
        JobState jobState = this.zeebeState.getJobState();
        JobRecord job = jobState.getJob(jobKey);
        if (job != null) {
            jobState.resolve(jobKey, job);
        }
    }
}

