/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.instance;

import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.workflow.EventOutput;
import io.zeebe.engine.processor.workflow.WorkflowInstanceCommandContext;
import io.zeebe.engine.processor.workflow.WorkflowInstanceCommandHandler;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;

public class CancelWorkflowInstanceHandler
implements WorkflowInstanceCommandHandler {
    private static final String WORKFLOW_NOT_FOUND_MESSAGE = "Expected to cancel a workflow instance with key '%d', but no such workflow was found";

    @Override
    public void handle(WorkflowInstanceCommandContext commandContext) {
        boolean canCancel;
        TypedRecord<WorkflowInstanceRecord> command = commandContext.getRecord();
        ElementInstance elementInstance = commandContext.getElementInstance();
        boolean bl = canCancel = elementInstance != null && elementInstance.canTerminate() && elementInstance.getParentKey() < 0L;
        if (canCancel) {
            EventOutput output = commandContext.getOutput();
            WorkflowInstanceRecord value = elementInstance.getValue();
            output.appendFollowUpEvent(command.getKey(), WorkflowInstanceIntent.ELEMENT_TERMINATING, value);
            commandContext.getResponseWriter().writeEventOnCommand(command.getKey(), (Intent)WorkflowInstanceIntent.ELEMENT_TERMINATING, (UnpackedObject)value, command);
        } else {
            commandContext.reject(RejectionType.NOT_FOUND, String.format(WORKFLOW_NOT_FOUND_MESSAGE, command.getKey()));
        }
    }
}

