/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.instance;

import io.zeebe.engine.Loggers;
import io.zeebe.engine.processor.CommandProcessor;
import io.zeebe.engine.processor.KeyGenerator;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.state.deployment.DeployedWorkflow;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.ElementInstanceState;
import io.zeebe.engine.state.instance.VariablesState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.msgpack.spec.MsgpackReaderException;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceCreationRecord;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.WorkflowInstanceCreationIntent;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class CreateWorkflowInstanceProcessor
implements CommandProcessor<WorkflowInstanceCreationRecord> {
    private static final String ERROR_MESSAGE_NO_IDENTIFIER_SPECIFIED = "Expected at least a bpmnProcessId or a key greater than -1, but none given";
    private static final String ERROR_MESSAGE_NOT_FOUND_BY_PROCESS = "Expected to find workflow definition with process ID '%s', but none found";
    private static final String ERROR_MESSAGE_NOT_FOUND_BY_PROCESS_AND_VERSION = "Expected to find workflow definition with process ID '%s' and version '%d', but none found";
    private static final String ERROR_MESSAGE_NOT_FOUND_BY_KEY = "Expected to find workflow definition with key '%d', but none found";
    private static final String ERROR_MESSAGE_NO_NONE_START_EVENT = "Expected to create instance of workflow with none start event, but there is no such event";
    private static final String ERROR_INVALID_VARIABLES_REJECTION_MESSAGE = "Expected to set variables from document, but the document is invalid: '%s'";
    private static final String ERROR_INVALID_VARIABLES_LOGGED_MESSAGE = "Expected to set variables from document, but the document is invalid";
    private final WorkflowState workflowState;
    private final ElementInstanceState elementInstanceState;
    private final VariablesState variablesState;
    private final KeyGenerator keyGenerator;
    private final WorkflowInstanceRecord newWorkflowInstance = new WorkflowInstanceRecord();

    public CreateWorkflowInstanceProcessor(WorkflowState workflowState, ElementInstanceState elementInstanceState, VariablesState variablesState, KeyGenerator keyGenerator) {
        this.workflowState = workflowState;
        this.elementInstanceState = elementInstanceState;
        this.variablesState = variablesState;
        this.keyGenerator = keyGenerator;
    }

    @Override
    public void onCommand(TypedRecord<WorkflowInstanceCreationRecord> command, CommandProcessor.CommandControl<WorkflowInstanceCreationRecord> controller, TypedStreamWriter streamWriter) {
        WorkflowInstanceCreationRecord record = command.getValue();
        DeployedWorkflow workflow = this.getWorkflow(record, controller);
        if (workflow == null || !this.isValidWorkflow(controller, workflow)) {
            return;
        }
        long workflowInstanceKey = this.keyGenerator.nextKey();
        if (!this.setVariablesFromDocument(controller, record, workflow.getKey(), workflowInstanceKey)) {
            return;
        }
        ElementInstance workflowInstance = this.createElementInstance(workflow, workflowInstanceKey);
        streamWriter.appendFollowUpEvent(workflowInstanceKey, (Intent)WorkflowInstanceIntent.ELEMENT_ACTIVATING, (UnpackedObject)workflowInstance.getValue());
        record.setInstanceKey(workflowInstanceKey).setBpmnProcessId(workflow.getBpmnProcessId()).setVersion(workflow.getVersion()).setKey(workflow.getKey());
        controller.accept((Intent)WorkflowInstanceCreationIntent.CREATED, record);
    }

    private boolean isValidWorkflow(CommandProcessor.CommandControl<WorkflowInstanceCreationRecord> controller, DeployedWorkflow workflow) {
        if (workflow.getWorkflow().getNoneStartEvent() == null) {
            controller.reject(RejectionType.INVALID_STATE, ERROR_MESSAGE_NO_NONE_START_EVENT);
            return false;
        }
        return true;
    }

    private boolean setVariablesFromDocument(CommandProcessor.CommandControl<WorkflowInstanceCreationRecord> controller, WorkflowInstanceCreationRecord record, long workflowKey, long workflowInstanceKey) {
        try {
            this.variablesState.setVariablesLocalFromDocument(workflowInstanceKey, workflowKey, record.getVariablesBuffer());
        }
        catch (MsgpackReaderException e) {
            Loggers.WORKFLOW_PROCESSOR_LOGGER.error(ERROR_INVALID_VARIABLES_LOGGED_MESSAGE, (Throwable)e);
            controller.reject(RejectionType.INVALID_ARGUMENT, String.format(ERROR_INVALID_VARIABLES_REJECTION_MESSAGE, e.getMessage()));
            return false;
        }
        return true;
    }

    private ElementInstance createElementInstance(DeployedWorkflow workflow, long workflowInstanceKey) {
        this.newWorkflowInstance.reset();
        this.newWorkflowInstance.setBpmnProcessId(workflow.getBpmnProcessId());
        this.newWorkflowInstance.setVersion(workflow.getVersion());
        this.newWorkflowInstance.setWorkflowKey(workflow.getKey());
        this.newWorkflowInstance.setWorkflowInstanceKey(workflowInstanceKey);
        this.newWorkflowInstance.setBpmnElementType(BpmnElementType.PROCESS);
        this.newWorkflowInstance.setElementId(workflow.getWorkflow().getId());
        this.newWorkflowInstance.setFlowScopeKey(-1L);
        ElementInstance instance = this.elementInstanceState.newInstance(workflowInstanceKey, this.newWorkflowInstance, WorkflowInstanceIntent.ELEMENT_ACTIVATING);
        return instance;
    }

    private DeployedWorkflow getWorkflow(WorkflowInstanceCreationRecord record, CommandProcessor.CommandControl controller) {
        DeployedWorkflow workflow;
        DirectBuffer bpmnProcessId = record.getBpmnProcessIdBuffer();
        if (bpmnProcessId.capacity() > 0) {
            workflow = record.getVersion() >= 0 ? this.getWorkflow(bpmnProcessId, record.getVersion(), controller) : this.getWorkflow(bpmnProcessId, controller);
        } else if (record.getKey() >= 0L) {
            workflow = this.getWorkflow(record.getKey(), controller);
        } else {
            controller.reject(RejectionType.INVALID_ARGUMENT, ERROR_MESSAGE_NO_IDENTIFIER_SPECIFIED);
            workflow = null;
        }
        return workflow;
    }

    private DeployedWorkflow getWorkflow(DirectBuffer bpmnProcessId, CommandProcessor.CommandControl controller) {
        DeployedWorkflow workflow = this.workflowState.getLatestWorkflowVersionByProcessId(bpmnProcessId);
        if (workflow == null) {
            controller.reject(RejectionType.NOT_FOUND, String.format(ERROR_MESSAGE_NOT_FOUND_BY_PROCESS, BufferUtil.bufferAsString((DirectBuffer)bpmnProcessId)));
        }
        return workflow;
    }

    private DeployedWorkflow getWorkflow(DirectBuffer bpmnProcessId, int version, CommandProcessor.CommandControl controller) {
        DeployedWorkflow workflow = this.workflowState.getWorkflowByProcessIdAndVersion(bpmnProcessId, version);
        if (workflow == null) {
            controller.reject(RejectionType.NOT_FOUND, String.format(ERROR_MESSAGE_NOT_FOUND_BY_PROCESS_AND_VERSION, BufferUtil.bufferAsString((DirectBuffer)bpmnProcessId), version));
        }
        return workflow;
    }

    private DeployedWorkflow getWorkflow(long key, CommandProcessor.CommandControl controller) {
        DeployedWorkflow workflow = this.workflowState.getWorkflowByKey(key);
        if (workflow == null) {
            controller.reject(RejectionType.NOT_FOUND, String.format(ERROR_MESSAGE_NOT_FOUND_BY_KEY, key));
        }
        return workflow;
    }
}

