/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.job;

import io.zeebe.engine.processor.CommandProcessor;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.state.instance.JobState;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobIntent;

public class CancelProcessor
implements CommandProcessor<JobRecord> {
    public static final String NO_JOB_FOUND_MESSAGE = "Expected to cancel job with key '%d', but no such job was found";
    private final JobState state;

    public CancelProcessor(JobState state) {
        this.state = state;
    }

    @Override
    public void onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long jobKey = command.getKey();
        JobRecord job = command.getValue();
        if (this.state.exists(jobKey)) {
            this.state.delete(jobKey, job);
            commandControl.accept((Intent)JobIntent.CANCELED, job);
        } else {
            commandControl.reject(RejectionType.NOT_FOUND, String.format(NO_JOB_FOUND_MESSAGE, jobKey));
        }
    }
}

